/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.accounting.service.resources;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.data.publishing.accounting.service.AccountingInitializer;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.SerializableList;
import org.gcube.smartgears.ApplicationManagerProvider;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=AccountingInitializer.class)
@Path(value="insert")
public class ResourceInsert {
    private static final Logger log = LoggerFactory.getLogger(ResourceInsert.class);
    private AccountingPersistence accountingPersistence;
    private AccountingInitializer appManager = (AccountingInitializer)ApplicationManagerProvider.get(AccountingInitializer.class);

    @POST
    @Path(value="/record/")
    @Consumes(value={"application/json"})
    public Response consumeLine(String line) throws Exception {
        try {
            log.debug("call consumeRecord:{}", (Object)line);
            this.accountingPersistence = this.appManager.getAccountingPersistence();
            log.debug("get persistence");
            Record r = DSMapper.unmarshal(Record.class, (String)line);
            log.debug("transform into record:{}", (Object)r);
            this.accountingPersistence.account(r);
            this.accountingPersistence.flush(100L, TimeUnit.MILLISECONDS);
            String output = "RESPONSE:" + r.toString();
            return Response.status((int)200).entity((Object)output).build();
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
            return Response.status((int)500).entity((Object)"").build();
        }
    }

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="records")
    public Response consumeRecords(@PathParam(value="records") String id, SerializableList<String> input) throws Exception {
        try {
            log.trace("call consumeRecords:{}");
            List valueList = input.getValuesList();
            this.accountingPersistence = this.appManager.getAccountingPersistence();
            for (String value : valueList) {
                Record r = DSMapper.unmarshal(Record.class, (String)value);
                this.accountingPersistence.account(r);
            }
            String output = "Ok";
            return Response.status((int)200).entity((Object)output).build();
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
            return Response.status((int)500).entity((Object)"").build();
        }
    }
}

