/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.gcube.data.publishing.ckan2zenodo.commons.Parsing;
import org.gcube.data.publishing.ckan2zenodo.model.CkanItemDescriptor;
import org.gcube.data.publishing.ckan2zenodo.model.CkanResource;
import org.gcube.data.publishing.ckan2zenodo.model.faults.TransformationException;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.Mapping;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.ResourceFilter;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.Contributor;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.DepositionMetadata;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.RelatedIdentifier;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.ZenodoDeposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Translator {
    private static final Logger log = LoggerFactory.getLogger(Translator.class);
    @NonNull
    private List<Mapping> mappings;
    @NonNull
    private ResourceFilter resourceFilter;

    public Translator() {
        this(Collections.EMPTY_LIST, new ResourceFilter(Collections.EMPTY_LIST));
    }

    public Translator(List<Mapping> mappings) {
        this(mappings, new ResourceFilter(Collections.EMPTY_LIST));
    }

    public ZenodoDeposition transform(CkanItemDescriptor toTransform, ZenodoDeposition deposition) throws TransformationException {
        String maintainerName;
        DepositionMetadata meta;
        log.debug("Transforming " + toTransform + ". Existing Deposition is : " + deposition);
        if (deposition == null) {
            deposition = new ZenodoDeposition();
        }
        if ((meta = deposition.getMetadata()) == null) {
            meta = new DepositionMetadata();
        }
        meta.setTitle(toTransform.getTitle());
        meta.setDescription(toTransform.getNotes());
        if (toTransform.isOpen().booleanValue()) {
            meta.setAccess_right(DepositionMetadata.AccessRights.open);
        } else {
            meta.setAccess_right(DepositionMetadata.AccessRights.restricted);
            meta.setAccess_conditions("Visit the VRE " + toTransform.getVRE() + " to access it.");
        }
        meta.setLicense(toTransform.getLicenseId());
        meta.setKeywords(new ArrayList<String>(toTransform.getTags()));
        String itemUrl = toTransform.getItemUrl();
        ArrayList<RelatedIdentifier> relatedIdentifiers = new ArrayList<RelatedIdentifier>();
        if (itemUrl != null) {
            relatedIdentifiers.add(new RelatedIdentifier(itemUrl, RelatedIdentifier.Relation.compiles));
        }
        meta.setRelated_identifiers(relatedIdentifiers);
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        String authorName = toTransform.getAuthor();
        if (authorName != null) {
            Contributor author = new Contributor(Contributor.Type.Producer);
            author.setName(authorName);
            contributors.add(author);
        }
        if ((maintainerName = toTransform.getAuthor()) != null) {
            Contributor maintainer = new Contributor(Contributor.Type.DataCurator);
            maintainer.setName(maintainerName);
            contributors.add(maintainer);
        }
        meta.setContributors(contributors);
        meta.setVersion(toTransform.getVersion());
        deposition.setMetadata(meta);
        return this.applyMappings(toTransform, deposition);
    }

    private ZenodoDeposition applyMappings(CkanItemDescriptor source, ZenodoDeposition target) throws TransformationException {
        try {
            ObjectMapper mapper = Parsing.getMapper();
            DocumentContext sourceCtx = JsonPath.using((Configuration)Parsing.JSON_PATH_ALWAYS_LIST_CONFIG).parse(source.getContent());
            DocumentContext targetCtx = JsonPath.using((Configuration)Parsing.JSON_PATH_ALWAYS_LIST_CONFIG).parse(mapper.writeValueAsString((Object)target));
            for (Mapping mapping : this.mappings) {
                try {
                    ArrayList<String> sourceValues = new ArrayList<String>();
                    for (Mapping.Source.Value v : mapping.getSource().getValues()) {
                        switch (v.getType()) {
                            case constant: {
                                sourceValues.add(v.getValue());
                                break;
                            }
                            case jsonPath: {
                                for (String s : (Collection)sourceCtx.read(v.getValue(), new Predicate[0])) {
                                    if (s == null || (s = s.trim()).isEmpty()) continue;
                                    sourceValues.add(s);
                                }
                                break;
                            }
                        }
                        if (!sourceValues.isEmpty()) break;
                    }
                    Iterator<Mapping.Source.Value> iterator = sourceValues.iterator();
                    while (iterator.hasNext()) {
                        String sourceValue;
                        String resultingValue = sourceValue = (String)((Object)iterator.next());
                        for (Mapping.Regexp regexp : mapping.getRegexp()) {
                            switch (regexp.getType()) {
                                case extract: {
                                    Pattern p = Pattern.compile(regexp.getTarget());
                                    Matcher m = p.matcher(resultingValue);
                                    if (m.find()) {
                                        resultingValue = m.group();
                                        break;
                                    }
                                    resultingValue = null;
                                    break;
                                }
                                case replace: {
                                    if (resultingValue == null) break;
                                    String replacement = regexp.getReplacement() != null ? regexp.getReplacement() : "";
                                    resultingValue = resultingValue.replaceAll(regexp.getTarget(), replacement);
                                }
                            }
                        }
                        resultingValue = mapping.getValueMapping().getOrDefault(sourceValue, resultingValue);
                        List targetElementFound = (List)targetCtx.read(mapping.getTargetPath(), new Predicate[0]);
                        if (targetElementFound == null || targetElementFound.size() == 0 || targetElementFound.get(0) == null) {
                            Parsing.addElement(targetCtx, mapping.getTargetPath());
                        }
                        targetCtx = targetCtx.put(mapping.getTargetPath(), mapping.getTargetElement(), (Object)resultingValue, new Predicate[0]);
                    }
                }
                catch (Throwable t) {
                    throw new TransformationException("Exception while applying " + mapping, t);
                }
            }
            String serializedOutput = targetCtx.jsonString();
            log.debug("Mapping complete. Going to return : " + serializedOutput);
            return (ZenodoDeposition)mapper.readValue(serializedOutput, ZenodoDeposition.class);
        }
        catch (Throwable t) {
            log.error("Unable to translate " + source + " using previous " + target, t);
            throw new TransformationException("Unable to translate " + source.getName(), t);
        }
    }

    public List<CkanResource> filterResources(CkanItemDescriptor source) throws TransformationException {
        try {
            ObjectMapper mapper = Parsing.getMapper();
            DocumentContext sourceCtx = JsonPath.using((Configuration)Parsing.JSON_PATH_ALWAYS_LIST_CONFIG).parse(source.getContent());
            ArrayList<CkanResource> toReturn = new ArrayList<CkanResource>();
            for (ResourceFilter.Filter f : this.resourceFilter.getFilters()) {
                JSONArray filtered = (JSONArray)sourceCtx.read(f.getConditions().get(0), new Predicate[0]);
                for (Object obj : filtered) {
                    Map map = (Map)obj;
                    toReturn.add((CkanResource)mapper.readValue(new JSONObject(map).toJSONString(), CkanResource.class));
                }
            }
            return toReturn;
        }
        catch (Throwable t) {
            log.error("Unable to filter resources. ", t);
            throw new TransformationException("Unable to filter " + source.getName() + " resources", t);
        }
    }

    @ConstructorProperties(value={"mappings", "resourceFilter"})
    public Translator(@NonNull List<Mapping> mappings, @NonNull ResourceFilter resourceFilter) {
        if (mappings == null) {
            throw new NullPointerException("mappings");
        }
        if (resourceFilter == null) {
            throw new NullPointerException("resourceFilter");
        }
        this.mappings = mappings;
        this.resourceFilter = resourceFilter;
    }
}

