/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.clients;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.gcube.data.publishing.ckan2zenodo.clients.Zenodo;
import org.gcube.data.publishing.ckan2zenodo.model.CkanResource;
import org.gcube.data.publishing.ckan2zenodo.model.UploadPolicy;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.FileDeposition;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.ZenodoDeposition;

public class UploadFilesCall
implements Callable<ZenodoDeposition> {
    private UploadPolicy policy;
    private Collection<CkanResource> toUpload;
    private ZenodoDeposition deposition;
    private Zenodo z;

    public UploadFilesCall(UploadPolicy policy, Collection<CkanResource> toUpload, ZenodoDeposition deposition, Zenodo z) {
        this.policy = policy;
        this.toUpload = toUpload;
        this.deposition = deposition;
        this.z = z;
    }

    @Override
    public ZenodoDeposition call() throws Exception {
        ZenodoDeposition dep = this.deposition;
        if (this.policy.equals((Object)UploadPolicy.DELETE_ALL)) {
            for (FileDeposition f : dep.getFiles()) {
                try {
                    this.z.deleteFile(dep.getId(), f);
                }
                catch (Throwable t) {
                    throw new Exception("Unable to delete " + f, t);
                }
            }
        }
        block9: for (CkanResource r : this.toUpload) {
            try {
                switch (this.policy) {
                    case SKIP_EXISTING: {
                        boolean found = false;
                        for (FileDeposition f : dep.getFiles()) {
                            if (!f.getFilename().equals(r.getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue block9;
                        this.z.uploadFile(dep, r.getName(), r.getUrl());
                        break;
                    }
                    case DELETE_EXISTING: {
                        for (FileDeposition f : dep.getFiles()) {
                            if (!f.getFilename().equals(r.getName())) continue;
                            this.z.deleteFile(dep.getId(), f);
                            break;
                        }
                    }
                    default: {
                        this.z.uploadFile(dep, r.getName(), r.getUrl());
                        break;
                    }
                }
            }
            catch (Throwable t) {
                throw new Exception("Unable to upload " + r.getName() + ".", t);
            }
        }
        return this.z.readDeposition(dep.getId());
    }
}

