/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.geoserver;

import java.awt.Color;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.bean.BoundsRest;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.engine.MakeStyle;
import org.gcube.data.publishing.gis.geoserver.Constants;
import org.gcube.data.publishing.gis.geoserver.Utils;
import org.gcube.data.publishing.gis.geoserver.db.DBUtils;
import org.gcube.data.publishing.gis.geoserver.db.Table;
import org.gcube.data.publishing.gis.geoserver.model.DBDescriptor;
import org.gcube.data.publishing.gis.geoserver.model.GeoServerDescriptor;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.CSquareConverter;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.GISInteraction;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.CSquarePoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GISData;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GISFile;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.GeometryPoint;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.StreamedGISData;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.BadRequestException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.DataParsingException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.NotSupportedDataTypeException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.UnreachableDestinationException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.requests.GISRequestConfiguration;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.requests.LayerGenerationRequest;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.requests.StyleGenerationRequest;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.requests.WMSGroupGenerationRequest;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.response.GeneratedLayerReport;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.response.GeneratedStyleReport;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.response.PublishingReport;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.response.PublishingStatus;
import org.gcube.data.streams.Stream;

public class GeoServerPlugin
implements GISInteraction {
    private static final String crs = "GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]]";
    private static GCUBELog logger = new GCUBELog(GeoServerPlugin.class);
    private CSquareConverter converter;
    private GeoCaller caller;
    private DBDescriptor postgis;
    private GeoServerDescriptor geoServer;
    private PublishingReport currentActivityReport = new PublishingReport();

    public GeoServerPlugin(CSquareConverter converter, GeoCaller caller, DBDescriptor db, GeoServerDescriptor geoServer) {
        this.geoServer = geoServer;
        this.converter = converter;
        this.caller = caller;
        this.postgis = db;
    }

    public PublishingReport publishData(GISData toPublishData, GISRequestConfiguration config) throws DataParsingException, NotSupportedDataTypeException, UnreachableDestinationException {
        try {
            if (toPublishData instanceof GISFile) {
                this.readFile((GISFile)toPublishData);
            } else {
                Table table = this.readStream((StreamedGISData)toPublishData);
                logger.trace((Object)("Created table " + table));
                if (config.getToGenerateStyles() != null) {
                    for (StyleGenerationRequest styleReq : config.getToGenerateStyles()) {
                        if (styleReq == null) continue;
                        try {
                            this.currentActivityReport.getGeneratedStyles().put(styleReq.getNameStyle(), this.generateStyle(styleReq));
                        }
                        catch (Exception e) {
                            logger.error((Object)("Unaebl to generate style " + styleReq), (Throwable)e);
                            this.currentActivityReport.getErrorMessages().put(styleReq.getNameStyle(), e.getMessage());
                        }
                    }
                }
                if (config.getToGenerateLayers() != null) {
                    for (LayerGenerationRequest layerRequest : config.getToGenerateLayers()) {
                        if (layerRequest == null) continue;
                        try {
                            this.currentActivityReport.getGeneratedLayers().put(layerRequest.getName(), this.generateLayer(table, layerRequest));
                        }
                        catch (Exception e) {
                            logger.error((Object)("Unaebl to generate layer " + layerRequest), (Throwable)e);
                            this.currentActivityReport.getErrorMessages().put(layerRequest.getName(), e.getMessage());
                        }
                    }
                }
                if (config.getToGenerateWMSGroups() != null) {
                    for (WMSGroupGenerationRequest groupRequest : config.getToGenerateWMSGroups()) {
                        if (groupRequest == null) continue;
                        this.currentActivityReport.getErrorMessages().put(groupRequest.getToGenerateGroupName(), "WMS Group are not supported by this plugin");
                    }
                }
                this.currentActivityReport.setStatus(PublishingStatus.COMPLETED);
            }
            return this.currentActivityReport;
        }
        catch (DataParsingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DataParsingException();
        }
    }

    private void readFile(GISFile toRead) throws IOException {
        logger.trace((Object)("Received GIS File " + toRead));
        logger.trace((Object)("File size : " + toRead.getFile().getTotalSpace()));
    }

    private Table readStream(StreamedGISData toRead) throws NotSupportedDataTypeException, DataParsingException, UnreachableDestinationException {
        logger.trace((Object)("Reading streaming data : " + toRead));
        if (toRead.getStreamedType().isAssignableFrom(CSquarePoint.class)) {
            logger.trace((Object)"Requesting csquare conversion to Geometries..");
            StreamedGISData toConvert = toRead;
            return this.readStream(new StreamedGISData(this.converter.convert(toConvert.getStream()), GeometryPoint.class));
        }
        if (toRead.getStreamedType().isAssignableFrom(GeometryPoint.class)) {
            Connection conn = null;
            try {
                logger.trace((Object)"Connecting to DB..");
                conn = DBUtils.getConnection(this.postgis.getEntryPoint(), this.postgis.getUser(), this.postgis.getPassword());
                Stream stream = toRead.getStream();
                PreparedStatement ps = null;
                Table toFill = null;
                logger.trace((Object)"Reading stream..");
                boolean continueProcess = true;
                while (stream.hasNext() && continueProcess) {
                    GeometryPoint point = (GeometryPoint)stream.next();
                    try {
                        if (toFill == null) {
                            toFill = DBUtils.createTable(conn, point);
                            logger.debug((Object)("Created table " + toFill));
                        }
                        if (ps == null) {
                            ps = DBUtils.prepareStatementForInsert(conn, toFill, point);
                        }
                        toFill.setRowCount((long)DBUtils.insertPoint(toFill, ps, point) + toFill.getRowCount());
                    }
                    catch (Exception e) {
                        if (toFill == null || ps == null) {
                            logger.error((Object)"Unexpected Exception, going to stop process ", (Throwable)e);
                            continueProcess = false;
                        }
                        logger.debug((Object)"Exception while inserting point ", (Throwable)e);
                    }
                }
                if (continueProcess) {
                    conn.commit();
                }
                return toFill;
            }
            catch (Exception e) {
                throw new UnreachableDestinationException((Throwable)e);
            }
        }
        throw new NotSupportedDataTypeException("Data type was " + toRead.getStreamedType());
    }

    private GeneratedStyleReport generateStyle(StyleGenerationRequest req) throws UnreachableDestinationException, BadRequestException, Exception {
        String style;
        GeneratedStyleReport report = new GeneratedStyleReport();
        report.setToGenerateStyle(req.getNameStyle());
        String actualStyleName = Utils.getUUID();
        logger.trace((Object)("Generating style " + req));
        if (req.getTypeValue() == Integer.class) {
            switch (req.getClusterScaleType()) {
                case logarithmic: {
                    style = MakeStyle.createStyleLog((String)actualStyleName, (String)req.getAttributeName().toLowerCase(), (int)req.getnClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Integer.parseInt(req.getMax()), (Object)Integer.parseInt(req.getMin()));
                    break;
                }
                default: {
                    style = MakeStyle.createStyle((String)actualStyleName, (String)req.getAttributeName().toLowerCase(), (int)req.getnClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Integer.parseInt(req.getMax()), (Object)Integer.parseInt(req.getMin()));
                    break;
                }
            }
        } else if (req.getTypeValue() == Float.class) {
            switch (req.getClusterScaleType()) {
                case logarithmic: {
                    style = MakeStyle.createStyleLog((String)actualStyleName, (String)req.getAttributeName().toLowerCase(), (int)req.getnClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Float.valueOf(Float.parseFloat(req.getMax())), (Object)Float.valueOf(Float.parseFloat(req.getMin())));
                    break;
                }
                default: {
                    style = MakeStyle.createStyle((String)actualStyleName, (String)req.getAttributeName().toLowerCase(), (int)req.getnClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Float.valueOf(Float.parseFloat(req.getMax())), (Object)Float.valueOf(Float.parseFloat(req.getMin())));
                    break;
                }
            }
        } else {
            throw new BadRequestException("Invalid type class : " + req.getTypeValue());
        }
        logger.trace((Object)("Submitting style " + req + " with name : " + actualStyleName));
        if (!this.caller.sendStyleSDL(style)) {
            throw new UnreachableDestinationException("Caller returned false");
        }
        report.setGeneratedStyle(actualStyleName);
        report.setStyleURI("N/A");
        return report;
    }

    private GeneratedLayerReport generateLayer(Table table, LayerGenerationRequest request) throws UnreachableDestinationException, BadRequestException, Exception {
        GeneratedLayerReport report = new GeneratedLayerReport();
        String featureTable = table.getTableName();
        String layerName = request.getName();
        HashMap<String, String> meta = request.getMetaData();
        if (meta == null) {
            meta = new HashMap<String, String>();
        }
        logger.debug((Object)("Generating " + request));
        try {
            FeatureTypeRest featureTypeRest = new FeatureTypeRest();
            featureTypeRest.setDatastore(this.geoServer.getDatastore());
            featureTypeRest.setEnabled(true);
            featureTypeRest.setLatLonBoundingBox(new BoundsRest(-180.0, 180.0, -85.5, 90.0, "EPSG:4326"));
            featureTypeRest.setNativeBoundingBox(new BoundsRest(-180.0, 180.0, -85.5, 90.0, "EPSG:4326"));
            featureTypeRest.setName(featureTable);
            featureTypeRest.setNativeName(featureTable);
            featureTypeRest.setProjectionPolicy("FORCE_DECLARED");
            featureTypeRest.setSrs("EPSG:4326");
            featureTypeRest.setNativeCRS(crs);
            featureTypeRest.setTitle(layerName);
            featureTypeRest.setWorkspace(this.geoServer.getWorkspace());
            StringBuilder description = new StringBuilder();
            meta.put("LAYER_NAME", featureTypeRest.getName());
            if (meta != null) {
                for (Map.Entry entry : meta.entrySet()) {
                    description.append((String)entry.getKey() + " : " + (String)entry.getValue() + " | ");
                }
            }
            logger.debug((Object)"Invoking Caller for registering layer : ");
            logger.debug((Object)("featureTypeRest.getNativeName : " + featureTypeRest.getNativeName()));
            logger.debug((Object)("featureTypeRest.getTitle : " + featureTypeRest.getTitle()));
            if (this.caller.addFeatureType(featureTypeRest, GeonetworkCommonResourceInterface.GeonetworkCategory.DATASETS, description.toString(), "")) {
                logger.debug((Object)("Add feature type returned true .. waiting for GS " + Constants.get().getGSWaitTime() + " ms"));
                try {
                    Thread.sleep(Constants.get().getGSWaitTime());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ArrayList<String> styles = new ArrayList<String>();
                for (String s : request.getToAssociateStyles()) {
                    if (this.currentActivityReport.getGeneratedStyles().containsKey(s)) {
                        styles.add(((GeneratedStyleReport)this.currentActivityReport.getGeneratedStyles().get(s)).getGeneratedStyle());
                        continue;
                    }
                    if (this.currentActivityReport.getErrorMessages().containsKey(s)) {
                        logger.trace((Object)("Skipped style " + s + ", previous error was " + (String)this.currentActivityReport.getErrorMessages().get(s)));
                        continue;
                    }
                    styles.add(s);
                }
                logger.debug((Object)("To associate styles : " + styles + ", default : " + (String)styles.get(request.getDefaultStyleIndex())));
                if (this.caller.setLayer(featureTypeRest, (String)styles.get(request.getDefaultStyleIndex()), styles)) {
                    report.setAssociatedStyles(styles);
                    report.setGeneratedLayerName(featureTable);
                    report.setToGenerateLayerName(request.getName());
                    report.setLayerUri(this.caller.getCurrentWmsGeoserver() + "/wms/" + featureTable);
                    return report;
                }
                throw new BadRequestException("Unable to set Layer " + request);
            }
            throw new UnreachableDestinationException("Add feature type returned false, layer has not been created.");
        }
        catch (Exception e) {
            logger.debug((Object)"Create layer threw an exception ", (Throwable)e);
            throw e;
        }
    }
}

