package org.gcube.data.publishing.gis.publisher.model;

import org.gcube.data.publishing.gis.publisher.model.faults.NotSupportedDataTypeException;
import org.gcube.data.publishing.gis.publisher.model.types.GISStreamedType;
import org.gcube.data.streams.Stream;

public class StreamedGISData<T extends GeoPoint> implements GISData{

	private Stream<T> stream;
	private Class<T> clazz;
	
	public StreamedGISData(Stream<T> stream, Class<T> handledPointClass) throws NotSupportedDataTypeException{
		super();
		this.stream = stream;
		this.clazz=handledPointClass;
		if(!clazz.isAssignableFrom(CSquarePoint.class)
			&&!clazz.isAssignableFrom(CoordinatePoint.class)
			&&!clazz.isAssignableFrom(GeometryPoint.class)) throw new NotSupportedDataTypeException();
	}

	@Override
	public GISStreamedType getType(){		
		if(clazz.isAssignableFrom(CSquarePoint.class))return GISStreamedType.CSQUARE_POINTS;
		else return GISStreamedType.COORDINATE_POINTS;		
	}
	
	public Class<T> getStreamedType() {
		return clazz;        
	}

	@Override
	public String getURI() {
		return stream.locator().toString();
	}
	
	public Stream<T> getStream() {
		return stream;
	}
}
