/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gis.publisher;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.util.UUID;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.data.publishing.gis.publisher.reports.StoredReport;

public class ServiceContext
extends GCUBEServiceContext {
    private static ServiceContext cache = new ServiceContext();
    private static final String DATABASE_URL = "jdbc:h2:mem:report;DB_CLOSE_DELAY=-1";
    private Dao<StoredReport, UUID> reportDao;

    public static ServiceContext getContext() {
        return cache;
    }

    protected String getJNDIName() {
        return "gcube/data/publishing/gispublisher";
    }

    protected void onInitialisation() throws Exception {
        super.onInitialisation();
        JdbcPooledConnectionSource connectionSource = new JdbcPooledConnectionSource("jdbc:h2:mem:occurrence;DB_CLOSE_DELAY=-1");
        this.reportDao = DaoManager.createDao((ConnectionSource)connectionSource, StoredReport.class);
        try {
            TableUtils.createTable((ConnectionSource)connectionSource, StoredReport.class);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unable to create Report Table", (Throwable)e);
        }
    }

    protected void onReady() throws Exception {
        super.onReady();
    }

    protected void onShutdown() throws Exception {
        super.onShutdown();
    }

    protected void onFailure() throws Exception {
        super.onFailure();
    }

    public Dao<StoredReport, UUID> getReportDao() {
        return this.reportDao;
    }
}

