package org.gcube.datapublishing.sdmx.datasource.tabman.config;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datapublishing.sdmx.datasource.config.ConfigurationManager;
import org.gcube.datapublishing.sdmx.datasource.config.impl.ConfigurationManagerImpl;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabmanDatasourceConfigurationManager extends ConfigurationManagerImpl implements ConfigurationManager {

	private Logger logger;
	private final String DEFAULT_NAME ="SDMXDataSource";
	private String name;
	
	public TabmanDatasourceConfigurationManager() {
		this.logger = LoggerFactory.getLogger(TabmanDatasourceConfigurationManager.class);
		
	}
	
	@Override
	public void init() {
		super.init();
		ApplicationContext context = ContextProvider.get();
		this.logger.debug("Tabman related configuration");
		this.logger.debug("Setting credentials");
		String scope = ScopeProvider.instance.get();
		this.logger.debug("User scope "+scope );
		
		if (scope == null)
		{
			
			ContainerContext containerContext = context.container();
			String token = containerContext.configuration().startTokens().iterator().next();
			this.logger.debug("Container token "+token);
			SecurityTokenProvider.instance.set(token);
			HostingNode containerProfile = containerContext.profile(HostingNode.class);
			this.logger.debug("Scopes "+containerProfile.scopes().asCollection());
			ScopeProvider.instance.set(containerProfile.scopes().asCollection().iterator().next());
		}
		
		
		this.name = context.name();
		
		if (name == null) name = DEFAULT_NAME;
		
	}

	public String getName() {
		return name;
	}
	
	
	
	
	
}
