package org.gcube.datapublishing.sdmx.impl.model;

import java.util.HashMap;
import java.util.Map;

import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryDescriptor;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryInterfaceType;

public class SDMXRegistryDescriptorImpl implements SDMXRegistryDescriptor {
	
	Map<SDMXRegistryInterfaceType, String> urls = new HashMap<SDMXRegistryInterfaceType, String>();
	
	public SDMXRegistryDescriptorImpl() {
	}
	
	public SDMXRegistryDescriptorImpl(String rest_url_V2_1, String rest_url_V2, String rest_url_V1,
			String soap_url_V2_1, String soap_url_V2, String soap_url_V1) {
		super();
		setRest_url_V2_1(rest_url_V2_1);
		setRest_url_V2(rest_url_V2);
		setRest_url_V1(rest_url_V1);
		setSoap_url_V2_1(soap_url_V2_1);
		setSoap_url_V2(soap_url_V2);
		setSoap_url_V1(soap_url_V1);
	}
	public String getRest_url_V2_1() {
		return urls.get(SDMXRegistryInterfaceType.RESTV2_1);
	}
	public void setRest_url_V2_1(String rest_url_V2_1) {
		urls.put(SDMXRegistryInterfaceType.RESTV2_1, rest_url_V2_1);
	}

	public String getRest_url_V2() {
		return urls.get(SDMXRegistryInterfaceType.RESTV2);
	}
	public void setRest_url_V2(String rest_url_V2) {
		urls.put(SDMXRegistryInterfaceType.RESTV2, rest_url_V2);
	}

	public String getRest_url_V1() {
		return urls.get(SDMXRegistryInterfaceType.RESTV1);
	}
	public void setRest_url_V1(String rest_url_V1) {
		urls.put(SDMXRegistryInterfaceType.RESTV1, rest_url_V1);
	}

	public String getSoap_url_V2_1() {
		return urls.get(SDMXRegistryInterfaceType.SOAPV2_1);
	}
	public void setSoap_url_V2_1(String soap_url_V2_1) {
		urls.put(SDMXRegistryInterfaceType.SOAPV2_1, soap_url_V2_1);
	}

	public String getSoap_url_V2() {
		return urls.get(SDMXRegistryInterfaceType.SOAPV2);
	}
	public void setSoap_url_V2(String soap_url_V2) {
		urls.put(SDMXRegistryInterfaceType.SOAPV2, soap_url_V2);
	}

	public String getSoap_url_V1() {
		return urls.get(SDMXRegistryInterfaceType.SOAPV1);
	}
	public void setSoap_url_V1(String soap_url_V1) {
		urls.put(SDMXRegistryInterfaceType.SOAPV1, soap_url_V1);
	}

	@Override
	public String getUrl(SDMXRegistryInterfaceType interfaceType) {
		return urls.get(interfaceType);
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("SDMXRegistryDescriptorImpl [urls=");
		builder.append(urls);
		builder.append("]");
		return builder.toString();
	}
	
}