/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import gr.i2s.fishgrowth.model.Modeler;
import gr.i2s.fishgrowth.model.Scenario;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil;
import org.gcube.data.simulfishgrowthdata.calc.ConsumptionScenarioExecutor;
import org.gcube.data.simulfishgrowthdata.calc.GlobalModelConsumptionExecutor;
import org.gcube.data.simulfishgrowthdata.calc.GlobalModelScenarioExecutor;
import org.gcube.data.simulfishgrowthdata.calc.WhatIfAnalysisExecutor;
import org.gcube.data.simulfishgrowthdata.model.GlobalModelWrapper;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioUtil
extends BaseUtil {
    public static final int KIND_EXECUTOR_OWN_DATA = 1;
    public static final int KIND_EXECUTOR_GLOBAL_MODEL = 2;
    private static final String _UPDATE_STATUS_ON_SITEID = "UPDATE Scenario SET statusId=:statusId WHERE simulModelId IN (SELECT id FROM SimulModel WHERE siteId = :siteId)";
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Scenario s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final Logger logger = LoggerFactory.getLogger(ScenarioUtil.class);

    public Scenario add(Session session, Scenario scenario) throws Exception {
        session.save((Object)scenario);
        session.flush();
        return scenario;
    }

    public Scenario add(Scenario scenario) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            this.add(session, scenario);
            session.getTransaction().commit();
            Scenario scenario2 = scenario;
            return scenario2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not add scenario [%s]", scenario), (Throwable)e);
            throw new Exception(String.format("Could not add scenario [%s]", scenario), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Scenario update(Scenario scenario) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            this.update(session, scenario);
            session.getTransaction().commit();
            Scenario scenario2 = scenario;
            return scenario2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not update scenario [%s]", scenario), (Throwable)e);
            throw new Exception(String.format("Could not update scenario [%s]", scenario), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Scenario update(Session session, Scenario scenario) throws Exception {
        session.update((Object)scenario);
        session.flush();
        return scenario;
    }

    public boolean delete(Session session, Long id) throws Exception {
        Scenario scenario = this.getScenario(session, id);
        if (scenario != null) {
            session.delete((Object)scenario);
            session.flush();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            this.delete(session, id);
            session.getTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete scenario [%s]", id), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Scenario getScenario(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Scenario scenario = this.getScenario(session, id);
            session.getTransaction().commit();
            Scenario scenario2 = scenario;
            return scenario2;
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve scenario [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not retrieve scenario [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Scenario getScenario(Session session, Long id) throws Exception {
        Scenario scenario = (Scenario)session.get(Scenario.class, (Serializable)id);
        return scenario;
    }

    public List<Scenario> getScenarios(String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getScenarios", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return Scenarios %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve scenarios for [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not retrieve scenarios for [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public Scenario executeScenario(Long id) throws Exception {
        Scenario scenario;
        Session session = null;
        try {
            logger.trace(String.format("start getScenarios", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Scenario toRet = this.executeScenario(session, id);
            session.getTransaction().commit();
            logger.trace(String.format("return Scenarios %s", toRet));
            scenario = toRet;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve scenarios for [%s]", id), (Throwable)e);
                throw new Exception(String.format("Could not retrieve scenarios for [%s]", id), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return scenario;
    }

    public Scenario executeScenario(Session session, Long id) throws Exception {
        try {
            Scenario scenario = this.getScenario(session, id);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("For [%s] I loaded [%s]", id, scenario));
            }
            new WhatIfAnalysisExecutor(session, scenario).run();
            return scenario;
        }
        catch (Exception e) {
            logger.info(String.format("Could not execute scenario [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not execute scenario [%s]", id), e);
        }
    }

    public Scenario executeScenario(Session session, Long id, int kind) throws Exception {
        if (kind == 1) {
            return this.executeScenario(session, id);
        }
        if (kind == 2) {
            Scenario scenario = this.getScenario(session, id);
            Modeler modeler = new ModelerUtil().getModeler(session, scenario.getModelerId());
            GlobalModelWrapper globalModel = new GlobalModelWrapper(session, modeler).create();
            return this.executeScenario(session, id, globalModel);
        }
        throw new Exception(String.format("Uknown kind [%s]", kind));
    }

    public Scenario executeScenario(Session session, Long id, GlobalModelWrapper globalModel) throws Exception {
        try {
            Scenario scenario = this.getScenario(session, id);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("For [%s] I loaded [%s]", id, scenario));
            }
            new GlobalModelScenarioExecutor(session, scenario, globalModel).run();
            return scenario;
        }
        catch (Exception e) {
            logger.info(String.format("Could not execute scenario [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not execute scenario [%s]", id), e);
        }
    }

    public String executeConsumptionScenario(String from, String to, Integer weight, Integer count, Long modelId) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            String toRet = this.executeConsumptionScenario(session, from, to, weight, count, modelId);
            session.getTransaction().commit();
            String string = toRet;
            return string;
        }
        catch (Exception e) {
            logger.error(String.format("Could not executeConsumptionScenario(from [%s], to [%s], weight [%s], count [%s], modelId [%s])", from, to, weight, count, modelId), (Throwable)e);
            throw new Exception(String.format("Could not executeConsumptionScenario(from [%s], to [%s], weight [%s], count [%s], modelId [%s])", from, to, weight, count, modelId), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public String executeConsumptionScenario(Session session, String from, String to, Integer weight, Integer count, Long modelId) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
        Scenario scenario = new Scenario();
        scenario.setStartDate(df.parse(from));
        scenario.setTargetDate(df.parse(to));
        scenario.setWeight((double)weight.intValue() / 100.0);
        scenario.setFishNo(count.intValue());
        scenario.setModelerId(modelId.longValue());
        ConsumptionScenarioExecutor executor = new ConsumptionScenarioExecutor(session, scenario);
        executor.run();
        return scenario.getResultsGraphData();
    }

    public String executeConsumptionScenario(String from, String to, Integer weight, Integer count, String latitude, String longitude, Long speciesId, Integer acceptableSiteCount, Integer upToGrade) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            String toRet = this.executeConsumptionScenario(session, from, to, weight, count, latitude, longitude, speciesId, acceptableSiteCount, upToGrade);
            session.getTransaction().commit();
            String string = toRet;
            return string;
        }
        catch (Exception e) {
            logger.error(String.format("Could not executeConsumptionScenario(from [%s], to [%s], weight [%s], count [%s], latitude [%s], longitude [%s], speciesId [%s])", from, to, weight, count, latitude, longitude, speciesId), (Throwable)e);
            throw new Exception(String.format("Could not executeConsumptionScenario(from [%s], to [%s], weight [%s], count [%s], latitude [%s], longitude [%s], speciesId [%s])", from, to, weight, count, latitude, longitude, speciesId), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public String executeConsumptionScenario(Session session, String from, String to, Integer weight, Integer count, String latitude, String longitude, Long speciesId, Integer acceptableSiteCount, Integer upToGrade) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
        Scenario scenario = new Scenario();
        scenario.setStartDate(df.parse(from));
        scenario.setTargetDate(df.parse(to));
        scenario.setWeight((double)weight.intValue() / 100.0);
        scenario.setFishNo(count.intValue());
        GlobalModelWrapper globalModel = new GlobalModelWrapper(session, latitude, longitude, speciesId, acceptableSiteCount, upToGrade).create();
        GlobalModelConsumptionExecutor executor = new GlobalModelConsumptionExecutor(scenario, globalModel);
        executor.run();
        return scenario.getResultsGraphData();
    }

    public int updateStatusOnSite(Session session, Long siteId, Long statusId) {
        NativeQuery q = session.createSQLQuery(_UPDATE_STATUS_ON_SITEID);
        q.setParameter("siteId", (Object)siteId);
        q.setParameter("statusId", (Object)statusId);
        return q.executeUpdate();
    }
}

