/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import gr.i2s.fishgrowth.model.Modeler;
import gr.i2s.fishgrowth.model.ModelerFull;
import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelerFullUtil
extends BaseUtil {
    static final Long neutral = new Long(-1L);
    public static final int KIND_GET_GLOBAL_MODEL_ON_SCENARIO = 0;
    public static final int KIND_GET_GLOBAL_MODEL_ON_MODELER = 1;
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.ModelerFull s WHERE s.ownerId = :ownerid AND ((:neutral=:species) OR (s.speciesId=:species)) ORDER BY s.designation ASC";
    private static final String _GET_ALL_ON_OWNERID_COUNT = "SELECT count(*) FROM gr.i2s.fishgrowth.model.ModelerFull s WHERE s.ownerId = :ownerid AND ((:neutral=:species) OR (s.speciesId=:species))";
    private static final Logger logger = LoggerFactory.getLogger(ModelerFullUtil.class);

    public Modeler add(ModelerFull modelerFull) throws Exception {
        return new ModelerUtil().add(new Modeler((Modeler)modelerFull));
    }

    public Modeler add(Session session, ModelerFull modelerFull) throws Exception {
        return new ModelerUtil().add(session, new Modeler((Modeler)modelerFull));
    }

    public Modeler update(ModelerFull modelerFull) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("original %s", modelerFull));
        }
        Modeler copy = new Modeler((Modeler)modelerFull);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("copy %s", copy));
        }
        return new ModelerUtil().update(copy);
    }

    public boolean delete(Long id) throws Exception {
        return new ModelerUtil().delete(id);
    }

    public boolean delete(Session session, Long id) throws Exception {
        return new ModelerUtil().delete(session, new ModelerUtil().getModeler(session, id));
    }

    public ModelerFull getModelerFull(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            ModelerFull modelerFull = this.getModelerFull(session, id);
            session.getTransaction().commit();
            ModelerFull modelerFull2 = modelerFull;
            return modelerFull2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not retrieve modeler full [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not retrieve modeler full [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public ModelerFull getModelerFull(Session session, Long id) throws Exception {
        ModelerFull modelerFull = (ModelerFull)session.get(ModelerFull.class, (Serializable)id);
        return modelerFull;
    }

    public List<ModelerFull> getModelerFulls(String ownerId, Integer start, Integer end, List<Long> status, Long species) throws Exception {
        List list;
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("reading %s for %s start %s end %s", "ModelerFull", ownerId, start, end));
        }
        Session session = null;
        try {
            logger.trace(String.format("start getModelerFulls", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId).setParameter("neutral", (Object)neutral).setParameter("species", (Object)(species == null ? neutral.longValue() : species.longValue()));
            if (start > 0) {
                q.setFirstResult(start.intValue());
            }
            if (end > 0) {
                if (end < start) {
                    end = start + 1;
                }
                q.setMaxResults(end - start);
            }
            List list2 = q.list();
            if (status != null && !status.isEmpty()) {
                ListIterator iter = list2.listIterator();
                while (iter.hasNext()) {
                    Modeler m = (Modeler)iter.next();
                    if (status.contains(m.getStatusId())) continue;
                    iter.remove();
                }
            }
            session.getTransaction().commit();
            logger.trace(String.format("return ModelerFulls %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve modeler full for [%s] start [%s] end [%s] status [%s] species [%s]", ownerId, start, end, status, species), (Throwable)e);
                throw new Exception(String.format("Could not retrieve modeler full for [%s] start [%s] end [%s] status [%s] species [%s]", ownerId, start, end, status, species), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public List<ModelerFull> getModelerFulls(String ownerId, List<Long> status, Long species) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getModelerFulls", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId).setParameter("neutral", (Object)neutral).setParameter("species", (Object)(species == null ? neutral.longValue() : species.longValue()));
            List list2 = q.list();
            logger.trace(String.format("status  requested [%s]", status));
            if (status != null && !status.isEmpty()) {
                ListIterator iter = list2.listIterator();
                while (iter.hasNext()) {
                    Modeler m = (Modeler)iter.next();
                    logger.trace(String.format("examining [%s]", m));
                    if (status.contains(m.getStatusId())) continue;
                    iter.remove();
                }
            }
            session.getTransaction().commit();
            logger.trace(String.format("return ModelerFulls %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve modeler full for [%s] status [%s] species [%s]", ownerId, status, species), (Throwable)e);
                throw new Exception(String.format("Could not retrieve modeler full for [%s] status [%s] species [%s]", ownerId, status, species), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public int getModelerFullCount(String ownerId, Long species) throws Exception {
        int n;
        Session session = null;
        try {
            logger.trace(String.format("start getModelerFulls", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID_COUNT).setParameter("ownerid", (Object)ownerId).setParameter("neutral", (Object)neutral).setParameter("species", (Object)(species == null ? neutral.longValue() : species.longValue()));
            Number count = (Number)q.uniqueResult();
            session.getTransaction().commit();
            logger.trace(String.format("return count %s", count));
            n = count.intValue();
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve modeler full count for [%s] species [%s]", ownerId, species), (Throwable)e);
                throw new Exception(String.format("Could not retrieve modeler full [%s] species [%s]", ownerId, species), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return n;
    }
}

