/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import gr.i2s.fishgrowth.model.Scenario;
import gr.i2s.fishgrowth.model.ScenarioFull;
import java.io.Serializable;
import java.util.List;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.api.base.ScenarioUtil;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioFullUtil
extends BaseUtil {
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.ScenarioFull s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final String _GET_ALL_ON_OWNERID_COUNT = "SELECT count(*) FROM gr.i2s.fishgrowth.model.ScenarioFull s WHERE s.ownerId = :ownerid";
    private static final Logger logger = LoggerFactory.getLogger(ScenarioFullUtil.class);

    public Scenario add(ScenarioFull scenarioFull) throws Exception {
        return new ScenarioUtil().add(new Scenario((Scenario)scenarioFull));
    }

    public Scenario add(Session session, ScenarioFull scenarioFull) throws Exception {
        return new ScenarioUtil().add(session, new Scenario((Scenario)scenarioFull));
    }

    public Scenario update(ScenarioFull scenarioFull) throws Exception {
        return new ScenarioUtil().update(new Scenario((Scenario)scenarioFull));
    }

    public boolean delete(Session session, Long id) throws Exception {
        return new ScenarioUtil().delete(session, id);
    }

    public boolean delete(Long id) throws Exception {
        return new ScenarioUtil().delete(id);
    }

    public ScenarioFull getScenarioFull(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            ScenarioFull scenarioFull = this.getScenarioFull(session, id);
            session.getTransaction().commit();
            ScenarioFull scenarioFull2 = scenarioFull;
            return scenarioFull2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not retrieve scenario full [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not retrieve scenario full [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public ScenarioFull getScenarioFull(Session session, Long id) throws Exception {
        ScenarioFull scenarioFull = (ScenarioFull)session.get(ScenarioFull.class, (Serializable)id);
        return scenarioFull;
    }

    public List<ScenarioFull> getScenarioFulls(String ownerId, Integer start, Integer end) throws Exception {
        List list;
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("reading %s for %s start %s end %s", "ScenarioFull", ownerId, start, end));
        }
        Session session = null;
        try {
            logger.trace(String.format("start getScenarioFulls with ownerid [%s]", ownerId));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            if (start > 0) {
                q.setFirstResult(start.intValue());
            }
            if (end > 0) {
                if (end < start) {
                    end = start + 1;
                }
                q.setMaxResults(end - start);
            }
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return ScenarioFulls %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve scenario full for [%s] start [%s] [%s]", ownerId, start, end), (Throwable)e);
                throw new Exception(String.format("Could not retrieve scenario full for [%s] start [%s] [%s]", ownerId, start, end), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public List<ScenarioFull> getScenarioFulls(String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getScenarioFulls with ownerid [%s]", ownerId));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return ScenarioFulls %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve retrieve scenario full for [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not retrieve scenario full for [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public int getScenarioFullCount(String ownerId) throws Exception {
        int n;
        Session session = null;
        try {
            logger.trace(String.format("start getScenarioFullCount with ownerid [%s]", ownerId));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID_COUNT).setParameter("ownerid", (Object)ownerId);
            Number count = (Number)q.uniqueResult();
            session.getTransaction().commit();
            logger.trace(String.format("return count %s", count));
            n = count.intValue();
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve scenario full count for [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not retrieve scenario full count for [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return n;
    }
}

