/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.model.verify;

import gr.i2s.fishgrowth.model.Scenario;
import org.apache.commons.lang.StringUtils;
import org.gcube.data.simulfishgrowthdata.model.verify.EntityVerify;

public class ScenarioVerify
extends EntityVerify<Scenario> {
    int MIN_FISH_NO = 100;
    int MAX_FISH_NO = 1000000;
    double MIN_WEIGHT = 1.0;
    double MAX_WEIGHT = 500.0;

    public ScenarioVerify(Scenario entity) {
        super(entity);
    }

    @Override
    public void verify() throws EntityVerify.VerifyException {
        EntityVerify.VerifyException toThrow = null;
        try {
            super.verify();
        }
        catch (EntityVerify.VerifyException e) {
            toThrow = e;
        }
        if (((Scenario)this.entity).getFishNo() < this.MIN_FISH_NO || ((Scenario)this.entity).getFishNo() > this.MAX_FISH_NO) {
            toThrow = new EntityVerify.VerifyException(String.format("Fish number is %s. It should be between %s and %s]", ((Scenario)this.entity).getFishNo(), this.MIN_FISH_NO, this.MAX_FISH_NO), toThrow);
        }
        if (((Scenario)this.entity).getWeight() < this.MIN_WEIGHT || ((Scenario)this.entity).getWeight() > this.MAX_WEIGHT) {
            toThrow = new EntityVerify.VerifyException(String.format("Fish weight is %.2f. It should be between %.2f and %.2f]", ((Scenario)this.entity).getWeight(), this.MIN_WEIGHT, this.MAX_WEIGHT), toThrow);
        }
        if (((Scenario)this.entity).getStartDate().after(((Scenario)this.entity).getTargetDate())) {
            toThrow = new EntityVerify.VerifyException(String.format("Start date %s is after target date %s.", ((Scenario)this.entity).getStartDateFrm(), ((Scenario)this.entity).getTargetDateFrm()), toThrow);
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    @Override
    public EntityVerify<Scenario> normalise() {
        super.normalise();
        ((Scenario)this.entity).setComments(StringUtils.trimToEmpty((String)((Scenario)this.entity).getComments()));
        return this;
    }
}

