/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Site;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/Site")
public class SiteUtil {
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Site s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final Logger logger = LoggerFactory.getLogger(SiteUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/json"})
    public Response add(Site site) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.save((Object)site);
            session.flush();
            session.getTransaction().commit();
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)site.getId()).build();
            return response;
        }
        catch (Exception e) {
            logger.error(String.format("Could not add site [%s]", site), (Throwable)e);
            Response response = Response.status((int)422).entity((Object)e).build();
            return response;
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    public Response update(Site site) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.update((Object)site);
            session.flush();
            session.getTransaction().commit();
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)site).build();
            return response;
        }
        catch (Exception e) {
            logger.error(String.format("Could not update site [%s]", site), (Throwable)e);
            Response response = Response.status((int)422).entity((Object)e).build();
            return response;
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Site site = (Site)session.get(Site.class, (Serializable)id);
            if (site != null) {
                session.delete((Object)site);
                session.flush();
            }
            session.getTransaction().commit();
            Response response = Response.status((Response.Status)Response.Status.OK).build();
            return response;
        }
        catch (Exception e) {
            logger.error(String.format("Could not delete site [%s]", id), (Throwable)e);
            Response response = Response.status((int)422).entity((Object)e).build();
            return response;
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Site getSite(@PathParam(value="id") Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Site site = (Site)session.get(Site.class, (Serializable)id);
            session.getTransaction().commit();
            Site site2 = site;
            return site2;
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve site [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    @GET
    @Path(value="/all/{ownerId}")
    public List<?> getSites(@PathParam(value="ownerId") String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getSiteFulls", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return SiteFulls %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve sites for ownerid [%s]", ownerId), (Throwable)e);
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }
}

