/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.simulfishgrowthdata.util.GCubeUtils;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseFilter.class);
    public static final String CTX_PARAM_DBNAME = "DBName";
    String dbName;

    public DatabaseFilter() {
        logger.error(String.format("DatabaseFilter ctor test error", new Object[0]));
        logger.debug(String.format("DatabaseFilter ctor test debug", new Object[0]));
        System.out.println(String.format("DatabaseFilter ctor", new Object[0]));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug("in doFilter");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = httpRequest.getHeader(key);
            if (!logger.isDebugEnabled()) continue;
            logger.debug(String.format("Header [%s]=[%s]", key, value));
        }
        String dbhost = httpRequest.getHeader("dbhost");
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("dbhost [%s]", dbhost));
        }
        if (dbhost != null) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("prefilling", new Object[0]));
            }
            String dbname = httpRequest.getHeader("dbname");
            String dbuser = httpRequest.getHeader("dbuser");
            String dbpass = httpRequest.getHeader("dbpass");
            GCubeUtils.prefillDBCredentials((String)dbhost, (String)dbname, (String)dbuser, (String)dbpass);
        }
        String scope = httpRequest.getHeader("scope");
        ScopeProvider.instance.set(scope);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("configuring Hibernate", new Object[0]));
        }
        HibernateUtil.configGently((String)this.dbName, (String)scope);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("configuring Hibernate - done", new Object[0]));
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig fConfig) throws ServletException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("DatabaseFilter init", new Object[0]));
        }
        this.dbName = fConfig.getInitParameter(CTX_PARAM_DBNAME);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("DatabaseFilter [%s]=[%s]", CTX_PARAM_DBNAME, this.dbName));
        }
    }
}

