package org.gcube.data.simulfishgrowthdata.api;

import java.util.List;
import java.util.ListIterator;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.simulfishgrowthdata.util.ConnectionUtil;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gr.i2s.fishgrowth.model.Modeler;

@Path("/Modeler")
public class ModelerUtil {
	@PUT
	@Consumes(MediaType.APPLICATION_JSON)
	public Response add(Modeler modeler) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.save(modeler);

			session.flush();

			session.getTransaction().commit();
			return Response.status(Response.Status.OK).entity(modeler.getId()).build();
		} catch (Exception e) {
			logger.error(String.format("Could not add modeler [%s]", modeler), e);
			return Response.status(ConnectionUtil.Status.UNPROCESSABLE_ENTITY).entity(e).build();
		} finally {
			HibernateUtil.closeSession(session);
		}
		// return Response.status(Response.Status.EXPECTATION_FAILED).build();
	}

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	public Response update(Modeler modeler) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.update(modeler);

			session.flush();

			session.getTransaction().commit();
			return Response.status(Response.Status.OK).entity(modeler).build();
		} catch (Exception e) {
			logger.error(String.format("Could not update modeler [%s]", modeler), e);
			return Response.status(ConnectionUtil.Status.UNPROCESSABLE_ENTITY).entity(e).build();
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	@DELETE
	@Path("/{id}")
	public Response delete(@PathParam("id") Long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Modeler modeler = (Modeler) session.get(Modeler.class, Long.valueOf(id));

			if (modeler != null) {
				session.delete(modeler);

				session.flush();
			}

			session.getTransaction().commit();
			return Response.status(Response.Status.OK).build();
		} catch (Exception e) {
			logger.error(String.format("Could not delete modeler [%s]", id), e);
			return Response.status(ConnectionUtil.Status.UNPROCESSABLE_ENTITY).entity(e).build();
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	@GET
	@Path("/{id}")
	@Produces({ MediaType.APPLICATION_JSON })
	public Modeler getModeler(@PathParam("id") Long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Modeler modeler = (Modeler) session.get(Modeler.class, Long.valueOf(id));

			session.getTransaction().commit();

			return modeler;
		} catch (Exception e) {
			logger.error(String.format("Could not retrieve modeler [%s]", id), e);
			throw new WebApplicationException(Response.Status.NOT_FOUND);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	@GET
	@Path("/all/{ownerId}")
	public List<?> getModelers(@PathParam("ownerId") String ownerId, @QueryParam("statuses") List<Long> statuses)
			throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("start getModelers"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", ownerId);

			List<?> list = q.list();
			if (statuses != null && !statuses.isEmpty())
				for (ListIterator<?> iter = list.listIterator(); iter.hasNext();) {
					Modeler m = (Modeler) iter.next();
					if (!statuses.contains(m.getStatusId())) {
						iter.remove();
					}
				}

			session.getTransaction().commit();

			logger.trace(String.format("return Modelers %s", list));
			return list;
		} catch (Exception e) {
			logger.error(String.format("Could not retrieve modelers for [%s]", ownerId), e);
			throw new WebApplicationException(Response.Status.NOT_FOUND);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	@DELETE
	@Path("/kpi/{id}")
	public void cleanKPIs(@PathParam("id") Long id) {
		if (logger.isTraceEnabled()) {
			logger.trace(String.format("clearing KPIs for model %s", id));
		}
		new SfrUtil().deleteAll(id);
		new FcrUtil().deleteAll(id);
		new MortalityUtil().deleteAll(id);

	}

	private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Modeler s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
	private static final Logger logger = LoggerFactory.getLogger(ModelerUtil.class);
}
