/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.SimilarSite;
import java.util.List;
import javax.websocket.server.PathParam;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.BaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimilarSiteUtil
extends BaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(SimilarSiteUtil.class);

    public Response add(SimilarSite entity) throws Exception {
        try {
            entity = new org.gcube.data.simulfishgrowthdata.api.base.SimilarSiteUtil().add(entity);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity.getId()).build();
        }
        catch (Exception e) {
            logger.info(String.format("Could not add similar sites [%s]", entity), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }

    public List<Long> getSimilarSites(@PathParam(value="siteId") Long siteId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SimilarSiteUtil().getSimilarSites(siteId);
        }
        catch (Exception e) {
            logger.info(String.format("Could not retrieve similar sites for siteid [%s]", siteId), (Throwable)e);
            throw new Exception(String.format("Could not retrieve similar sites for siteid [%s]", siteId), e);
        }
    }

    public List<Long> getSimilarSitesExcludingMe(@PathParam(value="siteId") Long siteId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SimilarSiteUtil().getSimilarSitesExcludingMe(siteId);
        }
        catch (Exception e) {
            logger.info(String.format("Could not retrieve similar sites exc me for siteid [%s]", siteId), (Throwable)e);
            throw new Exception(String.format("Could not retrieve similar sites exc me for siteid [%s]", siteId), e);
        }
    }

    public Response delete(@PathParam(value="siteId") Long siteId) throws Exception {
        try {
            new org.gcube.data.simulfishgrowthdata.api.base.SimilarSiteUtil().delete(siteId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete similar sites for siteid [%s]", siteId), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }

    public Response delete(@PathParam(value="siteId") Long siteId, @PathParam(value="similarId") Long similarId) throws Exception {
        try {
            new org.gcube.data.simulfishgrowthdata.api.base.SimilarSiteUtil().delete(siteId, similarId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete similar sites for siteid [%s] similarid [%s]", siteId, similarId), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }
}

