/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Sfr;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.BaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/Sfr")
public class SfrUtil
extends BaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(SfrUtil.class);

    @GET
    @Path(value="/all")
    public List<Sfr> getSfrs(@PathParam(value="modelId") Long modelId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.SfrUtil().getSfrs(modelId);
        }
        catch (Exception e) {
            logger.info(String.format("Could not retrieve sfr for modelid [%s]", modelId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteAll(@PathParam(value="modelId") Long modelId) {
        try {
            int count = new org.gcube.data.simulfishgrowthdata.api.base.SfrUtil().deleteAll(modelId);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)count).build();
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete sfr for modelid [%s]", modelId), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }
}

