/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.asfis;

import java.security.Key;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.data.spd.asfis.Utils;
import org.gcube.data.spd.asfis.capabilities.ClassificationCapabilityImpl;
import org.gcube.data.spd.asfis.capabilities.NamesMappingImpl;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class AsfisPlugin
extends AbstractPlugin {
    public static String dbDriver = "org.postgresql.Driver";
    public static String jdbc;
    public static String username;
    public static String password;
    public static final String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with ASFIS List of Species for Fishery Statistics Purposes (http://www.fao.org/fishery/collection/asfis/en)";
    public static final String citation = "Accessed through: ASFIS List of Species for Fishery Statistics Purposes at http://www.fao.org/fishery/collection/asfis/en on ";
    public static final String xslFile = "/ASFIS.xls";
    public static final String table = "asfis";
    public static final String driver = "org.postgresql.Driver";
    public static final String SPA = "Spanish";
    public static final String FRA = "French";
    public static final String ENG = "English";
    public static final String DEFAULTRANK = "Species";
    public static final String ANIMALIA = "Animalia";
    public static final String FAMILY = "Family";
    public static final String ORDER = "Order";
    public static final String VALIDATED = "Validated";
    GCUBELog logger = new GCUBELog(AsfisPlugin.class);

    public void initialize(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            username = ap.username();
            password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
        }
    }

    public void update(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            username = ap.username();
            password = ap.password();
        }
        super.update(res);
    }

    public String getDescription() {
        return "ASFIS Plugin";
    }

    public String getRepositoryName() {
        return "ASFIS";
    }

    public void shutdown() throws Exception {
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
                this.add(Capabilities.NamesMapping);
            }
        };
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public MappingCapability getMappingInterface() {
        return new NamesMappingImpl();
    }

    public void searchByScientificName(String word, ObjectWriter<ResultItem> writer, Condition ... properties) {
        block17: {
            ResultSet results = null;
            try {
                try {
                    results = Utils.createResultSetByName(word);
                    if (results == null) break block17;
                    while (results.next()) {
                        String id = results.getString(1);
                        String scientific_name = results.getString(2);
                        String author = results.getString(3);
                        String family = results.getString(4);
                        String order = results.getString(5);
                        String englishName = results.getString(6);
                        String frenchName = results.getString(7);
                        String spanishName = results.getString(8);
                        ResultItem rs = null;
                        try {
                            rs = this.createResultItem(id, scientific_name, author, family, order, englishName, frenchName, spanishName);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)"Error retrieving information ", (Throwable)e);
                        }
                        if (writer.isAlive()) {
                            if (rs == null) continue;
                            writer.write((Object)rs);
                            continue;
                        }
                        break;
                    }
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                    try {
                        if (results != null) {
                            results.close();
                        }
                    }
                    catch (SQLException ex) {
                        this.logger.error((Object)"sql Error", (Throwable)ex);
                    }
                }
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"sql Error", (Throwable)ex);
                }
            }
        }
    }

    private ResultItem createResultItem(String id, String ScName, String author, String family, String order, String englishName, String frenchName, String spanishName) {
        ResultItem item = new ResultItem(id, ScName);
        item.setRank(DEFAULTRANK);
        item.setAuthor(author);
        item.setCommonNames(Utils.setCommonNames(englishName, frenchName, spanishName));
        item.setCitation(Utils.createCitation());
        item.setCredits(Utils.createCredits());
        DataSet dataSet = new DataSet("ASFISid");
        dataSet.setName("ASFIS");
        DataProvider dp = new DataProvider("ASFISid");
        dp.setName("ASFIS");
        dataSet.setDataProvider(dp);
        item.setDataSet(dataSet);
        Taxon animaliaTaxon = new Taxon(ANIMALIA, ANIMALIA);
        animaliaTaxon.setRank(ANIMALIA);
        animaliaTaxon.setParent(null);
        Taxon familyTaxon = new Taxon(family, family);
        familyTaxon.setRank(FAMILY);
        familyTaxon.setParent(animaliaTaxon);
        Taxon orderTaxon = new Taxon(order, order);
        orderTaxon.setRank(ORDER);
        orderTaxon.setParent(familyTaxon);
        item.setParent(orderTaxon);
        return item;
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://termportal.fao.org/faoas/as/pages/img/ftTermTitle_en.gif", "http://www.fao.org/fishery/collection/asfis/en/", "The FAO Fisheries and Aquaculture Statistics and Information Service (FIPS) collates world capture and aquaculture production statistics at either the species, genus, family or higher taxonomic levels in 2 119 statistical categories (2011 data) referred to as species items.");
        return info;
    }
}

