/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.asfis;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPool;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.model.CommonName;

public class Utils {
    static GCUBELog logger = new GCUBELog(Utils.class);

    public static String createDate() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(now.getTime());
        return date;
    }

    public static String createCitation() {
        StringBuilder cit = new StringBuilder();
        cit.append("Accessed through: ASFIS List of Species for Fishery Statistics Purposes at http://www.fao.org/fishery/collection/asfis/en on ");
        cit.append(Utils.createDate());
        return cit.toString();
    }

    public static String createCredits() {
        String cred = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with ASFIS List of Species for Fishery Statistics Purposes (http://www.fao.org/fishery/collection/asfis/en)";
        cred = cred.replace("XDATEX", Utils.createDate());
        return cred;
    }

    public static List<CommonName> setCommonNames(String englishName, String frenchName, String spanishName) {
        ArrayList<CommonName> commonNames = new ArrayList<CommonName>();
        commonNames.add(new CommonName("English", englishName));
        commonNames.add(new CommonName("French", frenchName));
        commonNames.add(new CommonName("Spanish", spanishName));
        return commonNames;
    }

    public static ResultSet createResultSetByName(String scientificName) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String term = "%" + scientificName + "%";
            String query = "select TAXOCODE, Scientific_name, Author, Family, Order_rank, English_name, French_name, Spanish_name from asfis where UPPER(Scientific_name) like UPPER(?)";
            results = pool.selectPrestatement(query, term);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        return results;
    }
}

