/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.asfis.capabilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.asfis.Utils;
import org.gcube.data.spd.asfis.dbconnection.ConnectionPool;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Conditions> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ClosableWriter<TaxonomyItem> writer) {
        block10: {
            block7: while (true) {
                try {
                    while (ids.hasNext()) {
                        String id = ids.next();
                        TaxonomyItem item = null;
                        try {
                            item = this.retrieveTaxonById(id);
                            if (item == null) continue block7;
                            if (writer.isAlive() && item != null) {
                                writer.write((Object)item);
                                continue block7;
                            }
                            break block10;
                        }
                        catch (IdNotValidException e) {
                            this.logger.error((Object)"Id Not Valid", (Throwable)e);
                        }
                    }
                    break block10;
                }
                catch (Exception e) {
                    writer.write((StreamException)new StreamBlockingException("ASFIS", ""));
                    break block10;
                }
            }
            finally {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyItem retrieveTaxonById(String id) throws IdNotValidException {
        this.logger.trace((Object)("retrieveTaxonById " + id));
        ResultSet results = null;
        TaxonomyItem tax = null;
        try {
            results = Utils.createCompleteResultSetByID(id);
            if (results != null && results.next()) {
                String scientific_name = results.getString(1);
                String author = results.getString(2);
                String englishName = results.getString(3);
                String frenchName = results.getString(4);
                String spanishName = results.getString(5);
                String arabic_name = results.getString(11);
                String chinese_name = results.getString(12);
                String russian_name = results.getString(13);
                String parent_id = results.getString(6);
                String taxocode = results.getString(7);
                String isscaap = results.getString(8);
                String threeA_CODE = results.getString(9);
                String rank = results.getString(10);
                tax = this.createTaxonomyItem(id, scientific_name, author, englishName, frenchName, spanishName, parent_id, taxocode, isscaap, threeA_CODE, rank, arabic_name, chinese_name, russian_name, true);
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)"Id not valid exception", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"general Error", (Throwable)e);
                }
            }
        }
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildrenByTaxonId(String idParent) throws IdNotValidException, ExternalRepositoryException {
        this.logger.trace((Object)("retrieveTaxonChildrenByTaxonId " + idParent));
        ArrayList<TaxonomyItem> list = null;
        ResultSet results = null;
        try {
            results = this.createResultItemChilds(idParent);
            list = new ArrayList<TaxonomyItem>();
            while (results.next()) {
                String rank;
                String threeA_CODE;
                String isscaap;
                TaxonomyItem tax = null;
                String id = results.getString(1);
                String scientific_name = results.getString(2);
                String author = results.getString(3);
                String englishName = results.getString(4);
                String frenchName = results.getString(5);
                String spanishName = results.getString(6);
                String arabic_name = results.getString(11);
                String chinese_name = results.getString(12);
                String russian_name = results.getString(13);
                String taxocode = results.getString(7);
                tax = this.createTaxonomyItem(id, scientific_name, author, englishName, frenchName, spanishName, idParent, taxocode, isscaap = results.getString(8), threeA_CODE = results.getString(9), rank = results.getString(10), arabic_name, chinese_name, russian_name, false);
                if (tax == null) continue;
                tax.setParent(null);
                list.add(tax);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"sql Error", (Throwable)e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"general Error", (Throwable)e);
                }
            }
        }
        return list;
    }

    private TaxonomyItem createTaxonomyItem(String id, String scientific_name, String author, String englishName, String frenchName, String spanishName, String parent_id, String taxocode, String isscaap, String threeA_CODE, String rank, String arabic_name, String chinese_name, String russian_name, Boolean follow) throws SQLException {
        TaxonomyItem item = null;
        try {
            item = new TaxonomyItem(id);
            item.setScientificName(scientific_name);
            item.setRank(rank);
            item.setScientificNameAuthorship(author);
            item.setStatus(new TaxonomyStatus("Validated", TaxonomyStatus.Status.VALID));
            item.setCommonNames(Utils.setCommonNames(englishName, frenchName, spanishName, chinese_name, arabic_name, russian_name));
            item.setCitation(Utils.createCitation());
            item.setCredits(Utils.createCredits());
            if (follow & !id.equals(parent_id)) {
                item.setParent(this.retrieveTaxonById(parent_id));
            } else {
                item.setParent(null);
            }
            if (isscaap != null) {
                ElementProperty propertyIsscaap = new ElementProperty("ISSCAAP", isscaap);
                item.addProperty(propertyIsscaap);
            }
            if (threeA_CODE != null) {
                ElementProperty property3 = new ElementProperty("3A-CODE", threeA_CODE);
                item.addProperty(property3);
            }
            if (taxocode != null) {
                ElementProperty propertyTaxocode = new ElementProperty("TAXOCODE", taxocode);
                item.addProperty(propertyTaxocode);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"ID not valid Exception", (Throwable)e);
        }
        return item;
    }

    private ResultSet createResultItemChilds(String id) {
        ConnectionPool pool = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            String query = "select id, Scientific_name, Author, English_name, French_name, Spanish_name, TAXOCODE, ISSCAAP, threeA_CODE, rank, Arabic_name, Chinese_name, Russian_name from asfis where parent_id != id and parent_id = " + id;
            results = pool.selectPrestatement(query, null);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String name, ObjectWriter<TaxonomyItem> writer, Condition ... properties) {
        block14: {
            this.logger.trace((Object)("Retrive taxa by name " + name));
            ResultSet results = null;
            try {
                results = Utils.createResultSetByName(name);
                if (results == null) break block14;
                while (results.next()) {
                    String id = results.getString(1);
                    String scientific_name = results.getString(2);
                    String author = results.getString(3);
                    String englishName = results.getString(4);
                    String frenchName = results.getString(5);
                    String spanishName = results.getString(6);
                    String arabic_name = results.getString(12);
                    String chinese_name = results.getString(13);
                    String russian_name = results.getString(14);
                    String parent_id = results.getString(7);
                    String taxocode = results.getString(8);
                    String isscaap = results.getString(9);
                    String threeA_CODE = results.getString(10);
                    String rank = results.getString(11);
                    TaxonomyItem tax = this.createTaxonomyItem(id, scientific_name, author, englishName, frenchName, spanishName, parent_id, taxocode, isscaap, threeA_CODE, rank, arabic_name, chinese_name, russian_name, true);
                    if (writer.isAlive() && tax != null) {
                        writer.write((Object)tax);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                writer.write((StreamException)new StreamBlockingException("ASFIS", ""));
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"general Error", (Throwable)e);
                    }
                }
            }
        }
    }
}

