/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.gbif.dwc.terms.ConceptTerm;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveFactory;
import org.gbif.dwc.text.StarRecord;
import org.gbif.dwc.text.UnsupportedArchiveException;
import org.gbif.utils.file.ClosableIterator;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.Database;

class UpdateThread
extends Thread {
    static GCUBELog logger = new GCUBELog(UpdateThread.class);

    UpdateThread() {
        super("Thread");
        this.start();
    }

    @Override
    public void run() {
        logger.trace((Object)"Irmng DB will be updated in 30 days from now");
        while (true) {
            try {
                while (true) {
                    this.update();
                    UpdateThread.sleep(2592000000L);
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"InterruptedException", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected void update() {
        try {
            URL url = new URL("http://www.cmar.csiro.au/datacentre/downloads/IRMNG_DWC.zip");
            File tempFolder = File.createTempFile("irmng-folder", "");
            tempFolder.delete();
            tempFolder.mkdir();
            if (this.downloadFromUrl(url, tempFolder + "/IRMNG_DWC.zip")) {
                this.openArch(tempFolder);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFromUrl(URL url, String string) throws IOException {
        logger.trace((Object)"down");
        boolean flag = false;
        logger.trace((Object)("Downloading " + string));
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int len;
            URLConnection urlConn = url.openConnection();
            is = urlConn.getInputStream();
            fos = new FileOutputStream(string);
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            flag = true;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        return flag;
    }

    protected void openArch(File tempFolder) {
        try {
            logger.trace((Object)tempFolder);
            Archive arch = ArchiveFactory.openArchive((File)new File(tempFolder + "/IRMNG_DWC.zip"), (File)tempFolder);
            if (!arch.getCore().hasTerm((ConceptTerm)DwcTerm.scientificName)) {
                logger.trace((Object)"This application requires dwc-a with scientific names");
                System.exit(1);
            }
            Database database = null;
            database = new Database();
            database.connect();
            ClosableIterator iter = arch.iterator();
            String stmt = null;
            ResultSet result = null;
            ArrayList<String> terms = new ArrayList<String>();
            while (iter.hasNext()) {
                StarRecord dwc = (StarRecord)iter.next();
                terms.add(dwc.core().id());
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.scientificName));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.scientificNameAuthorship));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.genus));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.specificEpithet));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.family));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.taxonRank));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.taxonomicStatus));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.nomenclaturalStatus));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.nameAccordingTo));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.originalNameUsageID));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.namePublishedIn));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.acceptedNameUsageID));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.parentNameUsage));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.parentNameUsageID));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.taxonRemarks));
                terms.add(dwc.core().value((ConceptTerm)DcTerm.modified));
                terms.add(dwc.core().value((ConceptTerm)DwcTerm.nomenclaturalCode));
                result = database.get("select count(*) from taxon where taxonid = '" + dwc.core().id() + "'");
                if (result.next()) {
                    stmt = result.getInt(1) == 0 ? "insert into taxon (taxonid, scientificname, scientificnameauthorship, genus, specificepithet, family, taxonrank, taxonomicstatus, nomenclaturalstatus, nameaccordingto, originalnameusageid, namepublishedin, acceptednameusageid, parentnameusage, parentnameusageid, taxonremarks, modified, nomenclaturalcode) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" : "update taxon set taxonid = ?, scientificname = ?, scientificnameauthorship = ?, genus = ?, specificepithet = ?, family = ?, taxonrank = ?, taxonomicstatus = ?, nomenclaturalstatus = ?, nameaccordingto = ?, originalnameusageid = ?, namepublishedin = ?, acceptednameusageid = ?, parentnameusage = ?, parentnameusageid = ?, taxonremarks = ?, modified = ?, nomenclaturalcode = ? where taxonid ='" + dwc.core().id() + "'";
                    if (!database.preStatement(stmt, terms)) {
                        logger.trace((Object)"error");
                    }
                    terms.clear();
                }
                result.close();
            }
            logger.trace((Object)"completed!");
            database.shutDown();
        }
        catch (UnsupportedArchiveException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

