/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.Database;
import org.gcube.data.spd.irmng.DateUtil;
import org.gcube.data.spd.plugin.fwk.model.Taxon;

public class Utils {
    static GCUBELog logger = new GCUBELog(Utils.class);

    public static Taxon createTaxonomy(String id) {
        Taxon t = null;
        ResultSet results = null;
        Database database = null;
        try {
            try {
                database = new Database();
                database.connect();
                results = database.get("select parentnameusageid, scientificname, taxonrank, scientificnameauthorship from taxon where taxonid = '" + id + "'");
                if (results.next()) {
                    String id_parent = results.getString(1);
                    t = new Taxon(String.valueOf(id));
                    t.setScientificName(results.getString(2));
                    t.setRank(results.getString(3));
                    t.setCitation(results.getString(4));
                    if (id_parent != null) {
                        t.setParent(Utils.createTaxonomy(id_parent));
                    } else {
                        t.setParent(null);
                    }
                    results.close();
                }
            }
            catch (SQLException sqlExcept) {
                logger.error((Object)"sql Error", (Throwable)sqlExcept);
                try {
                    results.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"sql Error", (Throwable)e);
                }
                database.shutDown();
            }
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                logger.error((Object)"sql Error", (Throwable)e);
            }
            database.shutDown();
        }
        return t;
    }

    public static Calendar getCalendar(String date1) {
        Calendar cal = null;
        Date date = DateUtil.getInstance().parse(date1);
        if (date != null) {
            cal = Calendar.getInstance();
            cal.setTime(new Date(date.getTime()));
        }
        return cal;
    }

    public static String setScName(String id, String rank) {
        String scientificName = "";
        if (rank != null) {
            scientificName = rank.equals("family") ? Utils.getScientifiName(id, "family") : (rank.equals("genus") ? Utils.getScientifiName(id, "genus") : (rank.equals("species") ? String.valueOf(Utils.getScientifiName(id, "genus")) + " " + Utils.getScientifiName(id, "specificepithet") : Utils.getScientifiName(id, "scientificname")));
        }
        return scientificName;
    }

    private static String getScientifiName(String id, String rank) {
        String scientificName = "";
        ResultSet results = null;
        Database database = null;
        try {
            try {
                database = new Database();
                database.connect();
                results = database.get("select " + rank + " from taxon where taxonid = '" + id + "'");
                if (results.next()) {
                    scientificName = results.getString(1);
                }
                results.close();
            }
            catch (SQLException sqlExcept) {
                logger.error((Object)"sql Error", (Throwable)sqlExcept);
                try {
                    results.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"sql Error", (Throwable)e);
                }
                database.shutDown();
            }
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                logger.error((Object)"sql Error", (Throwable)e);
            }
            database.shutDown();
        }
        return scientificName;
    }
}

