/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.Database;
import org.gcube.data.spd.irmng.IrmngPlugin;
import org.gcube.data.spd.irmng.Utils;

class CreateDBThread
extends Thread {
    static GCUBELog logger = new GCUBELog(Utils.class);

    CreateDBThread() {
        super("Thread");
        this.start();
    }

    @Override
    public void run() {
        try {
            logger.trace((Object)"Create tables...");
            if (CreateDBThread.createDB()) {
                logger.trace((Object)"Done.");
            }
        }
        catch (IOException e) {
            logger.error((Object)"IO Error", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"sql Error", (Throwable)e);
        }
    }

    public static boolean createDB() throws SQLException, IOException {
        Database database = null;
        try {
            database = new Database();
            if (database.connect()) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(IrmngPlugin.class.getResourceAsStream("/createIrmngDb.sql")));
                while ((line = br.readLine()) != null) {
                    boolean updateQuery = database.update(line);
                    if (updateQuery) continue;
                    logger.trace((Object)("Error executing : " + line));
                    return false;
                }
            }
        }
        finally {
            database.shutDown();
        }
        return true;
    }
}

