/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.Utils;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPool;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.irmng.dbconnection.RSItem;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.plugin.fwk.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String id) throws IdNotValidException, MethodNotSupportedException, ExternalRepositoryException {
        this.logger.trace((Object)("getSynonimnsById " + id));
        ResultSet results = null;
        try {
            results = this.getSynRSItem(id);
            if (results != null) {
                String idSyn = null;
                while (results.next()) {
                    idSyn = results.getString(1);
                    TaxonomyItem tax = this.retrieveTaxonById(idSyn);
                    if (tax == null) continue;
                    writer.put((Object)tax);
                }
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)"sql Error", (Throwable)ex);
        }
        finally {
            writer.close();
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getSynRSItem(String id) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = ?";
            results = pool.selectPrestatement(query, id);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id_parent) {
        ArrayList<TaxonomyItem> list;
        block20: {
            this.logger.trace((Object)("retrieveTaxonChildsByTaxonId " + id_parent));
            list = null;
            ResultSet results = null;
            try {
                results = this.getRSItemChildren(id_parent);
                if (results == null) break block20;
                list = new ArrayList<TaxonomyItem>();
                while (results.next()) {
                    RSItem item = null;
                    try {
                        item = new RSItem();
                        item.setId(results.getString(1));
                        item.setRank(results.getString(2));
                        item.setAuthor(results.getString(3));
                        item.setStatus(results.getString(4));
                        item.setModified(results.getString(5));
                        item.setAcceptednameusageid(results.getString(6));
                        item.setNameaccordingto(results.getString(7));
                        item.setParentId(id_parent);
                        TaxonomyItem tax = this.createTaxonomyItem(item, false);
                        list.add(tax);
                    }
                    finally {
                        if (item == null) continue;
                        try {
                            item.finalize();
                        }
                        catch (Throwable e) {
                            this.logger.error((Object)"Error deleting RSItem", e);
                        }
                    }
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"sql Error", (Throwable)ex);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getRSItemChildren(String id) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, nameaccordingto from taxon where parentnameusageid = ?";
            results = pool.selectPrestatement(query, id);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return results;
    }

    private TaxonomyStatus setTaxStatus(String status, String syn_parent) {
        TaxonomyStatus tax = null;
        tax = status != null ? (status.equals("accepted") ? new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED) : (status.equals("valid") ? new TaxonomyStatus("valid", TaxonomyStatus.Status.VALID) : (status.equals("synonym") ? new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, syn_parent, "synonym") : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN)))) : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN);
        return tax;
    }

    public void searchByCommonName(String name, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
        block20: {
            this.logger.trace((Object)("searchByScientificName " + scientificName));
            ResultSet results = null;
            try {
                results = this.getRSItemByName(scientificName);
                if (results == null) break block20;
                while (results.next()) {
                    RSItem item = null;
                    try {
                        item = new RSItem();
                        item.setId(results.getString(1));
                        item.setRank(results.getString(2));
                        item.setAuthor(results.getString(3));
                        item.setStatus(results.getString(4));
                        item.setModified(results.getString(5));
                        item.setAcceptednameusageid(results.getString(6));
                        item.setParentId(results.getString(7));
                        item.setNameaccordingto(results.getString(8));
                        TaxonomyItem tax = this.createTaxonomyItem(item, true);
                        if (tax == null) continue;
                        writer.put((Object)tax);
                    }
                    finally {
                        if (item == null) continue;
                        try {
                            item.finalize();
                        }
                        catch (Throwable e) {
                            this.logger.error((Object)"Error deleting RSItem", e);
                        }
                    }
                }
            }
            catch (SQLException sqlExcept) {
                this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
            }
            finally {
                writer.close();
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"sql Error", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getRSItemByName(String scientificName) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String name = "%" + scientificName + "%";
            String query = "select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid, nameaccordingto from taxon where UPPER(scientificname) like UPPER(?)";
            results = pool.selectPrestatement(query, name);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)"SQLException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {
        try {
            while (ids.hasNext()) {
                String id = ids.next();
                TaxonomyItem item = this.retrieveTaxonById(id);
                writer.put((Object)item);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"ExceptionPrintStackTrace", (Throwable)e);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaxonomyItem createTaxonomyItem(RSItem rs, boolean flag) throws SQLException {
        Calendar dateModified = Utils.getCalendar(rs.getModified());
        TaxonomyItem item = null;
        try {
            item = new TaxonomyItem(rs.getId());
            item.setScientificName(Utils.setScName(rs.getId(), rs.getRank()));
            item.setAuthor(rs.getAuthor());
            item.setRank(rs.getRank());
            item.setCredits(Utils.createCredits());
            StringBuilder cit = new StringBuilder();
            String citation = rs.getNameaccordingto();
            if (citation != null) {
                cit.append(citation);
                cit.append(". ");
            }
            cit.append(Utils.createCitation());
            item.setCitation(cit.toString());
            item.setStatus(this.setTaxStatus(rs.getStatus(), rs.getAcceptednameusageid()));
            item.setModified(dateModified);
            if (flag) {
                String id_parent = rs.getParentId();
                if (id_parent != null) {
                    try {
                        item.setParent(this.retrieveTaxonById(id_parent));
                    }
                    catch (IdNotValidException e) {
                        this.logger.error((Object)"Id Not Valid", (Throwable)e);
                    }
                }
            } else {
                item.setParent(null);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.finalize();
                }
                catch (Throwable e) {
                    this.logger.error((Object)"Error deleting RSItem", e);
                }
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyItem retrieveTaxonById(String id) throws IdNotValidException {
        TaxonomyItem item = null;
        RSItem rs = null;
        try {
            rs = this.getRSItemById(id);
            if (rs != null) {
                try {
                    item = this.createTaxonomyItem(rs, true);
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.finalize();
                }
                catch (Throwable e) {
                    this.logger.error((Object)"Error deleting RSItem", e);
                }
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RSItem getRSItemById(String id) {
        RSItem item = null;
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet result = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid, nameaccordingto from taxon where taxonid = ?";
            result = pool.selectPrestatement(query, id);
            if (result != null && result.next()) {
                item = new RSItem();
                item.setId(id);
                item.setRank(result.getString(1));
                item.setAuthor(result.getString(2));
                item.setStatus(result.getString(3));
                item.setModified(result.getString(4));
                item.setAcceptednameusageid(result.getString(5));
                item.setParentId(result.getString(6));
                item.setNameaccordingto(result.getString(7));
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        return item;
    }
}

