/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng.capabilities;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.Utils;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPool;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPoolException;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Conditions> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String id) throws IdNotValidException, MethodNotSupportedException, ExternalRepositoryException {
        this.logger.trace((Object)("getSynonimnsById " + id));
        ResultSet results = null;
        try {
            results = this.getSynRSItem(id);
            String idSyn = null;
            if (results != null) {
                while (results.next()) {
                    idSyn = results.getString(1);
                    TaxonomyItem tax = this.retrieveTaxonById(idSyn);
                    if (tax == null || !writer.isAlive()) continue;
                    writer.write((Object)tax);
                }
            }
        }
        catch (SQLException ex) {
            writer.write((StreamException)new StreamBlockingException());
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getSynRSItem(String id) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = ?";
            results = pool.selectPrestatement(query, id);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id_parent) {
        this.logger.trace((Object)("retrieveTaxonChildsByTaxonId " + id_parent));
        ArrayList<TaxonomyItem> list = null;
        ResultSet rs = null;
        try {
            rs = this.getRSItemChildren(id_parent);
            list = new ArrayList<TaxonomyItem>();
            if (rs != null) {
                while (rs.next()) {
                    try {
                        String id = rs.getString(1);
                        String rank = rs.getString(2);
                        String author = rs.getString(3);
                        String status = rs.getString(4);
                        String modified = rs.getString(5);
                        String acceptednameusageid = rs.getString(6);
                        String nameaccordingto = rs.getString(7);
                        String name = rs.getString(8);
                        TaxonomyItem item = this.createTaxonomyItem(id, rank, author, status, modified, acceptednameusageid, nameaccordingto, name, id_parent, true);
                        list.add(item);
                    }
                    catch (SQLException ex) {
                        this.logger.error((Object)"sql Error", (Throwable)ex);
                    }
                }
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)"sql Error", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getRSItemChildren(String id) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, nameaccordingto, name from taxon where parentnameusageid = ?";
            results = pool.selectPrestatement(query, id);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return results;
    }

    private TaxonomyStatus setTaxStatus(String status, String syn_parent) {
        TaxonomyStatus tax = null;
        tax = status != null ? (status.equals("accepted") ? new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED) : (status.equals("valid") ? new TaxonomyStatus("valid", TaxonomyStatus.Status.VALID) : (status.equals("synonym") ? new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, syn_parent, "synonym") : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN)))) : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN);
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String word, ObjectWriter<TaxonomyItem> writer, Condition ... properties) {
        this.logger.trace((Object)("searchByScientificName " + word));
        ResultSet rs = null;
        try {
            rs = this.getRSItemByName(word);
            if (rs != null) {
                while (rs.next()) {
                    try {
                        String id = rs.getString(1);
                        String rank = rs.getString(2);
                        String author = rs.getString(3);
                        String status = rs.getString(4);
                        String modified = rs.getString(5);
                        String acceptednameusageid = rs.getString(6);
                        String nameaccordingto = rs.getString(7);
                        String id_parent = rs.getString(8);
                        String name = rs.getString(9);
                        TaxonomyItem tax = this.createTaxonomyItem(id, rank, author, status, modified, acceptednameusageid, nameaccordingto, name, id_parent, true);
                        if (tax == null || !writer.isAlive()) continue;
                        writer.write((Object)tax);
                    }
                    catch (Exception e) {
                        writer.write((StreamException)new StreamBlockingException());
                    }
                }
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getRSItemByName(String scientificName) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String name = "%" + scientificName + "%";
            String query = "select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, nameaccordingto, parentnameusageid, name from taxon where UPPER(name) like UPPER(?)";
            results = pool.selectPrestatement(query, name);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)"SQLException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ClosableWriter<TaxonomyItem> writer) {
        try {
            while (ids.hasNext()) {
                TaxonomyItem item = this.retrieveTaxonById(ids.next());
                if (!writer.isAlive()) continue;
                writer.write((Object)item);
            }
        }
        catch (Exception e) {
            writer.write((StreamException)new StreamBlockingException());
        }
        finally {
            writer.close();
        }
    }

    private TaxonomyItem createTaxonomyItem(String id, String rank, String author, String status, String modified, String acceptednameusageid, String nameaccordingto, String name, String parentId, boolean flag) throws SQLException {
        TaxonomyItem item = null;
        try {
            item = new TaxonomyItem(id);
            Calendar dateModified = Utils.getCalendar(modified);
            item.setScientificName(name);
            item.setAuthor(author);
            item.setRank(rank);
            item.setCredits(Utils.createCredits());
            StringBuilder cit = new StringBuilder();
            if (nameaccordingto != null) {
                cit.append(nameaccordingto);
                cit.append(". ");
            }
            cit.append(Utils.createCitation());
            item.setCitation(cit.toString());
            item.setStatus(this.setTaxStatus(status, acceptednameusageid));
            item.setModified(dateModified);
            if (flag) {
                if (parentId != null) {
                    try {
                        item.setParent(this.retrieveTaxonById(parentId));
                    }
                    catch (IdNotValidException e) {
                        this.logger.error((Object)"Id Not Valid", (Throwable)e);
                    }
                }
            } else {
                item.setParent(null);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception", (Throwable)e);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyItem retrieveTaxonById(String id) throws IdNotValidException {
        TaxonomyItem item = null;
        ResultSet rs = null;
        try {
            rs = this.getRSItemById(id);
            if (rs != null && rs.next()) {
                try {
                    String rank = rs.getString(1);
                    String author = rs.getString(2);
                    String status = rs.getString(3);
                    String modified = rs.getString(4);
                    String acceptednameusageid = rs.getString(5);
                    String nameaccordingto = rs.getString(6);
                    String parentId = rs.getString(7);
                    String name = rs.getString(8);
                    item = this.createTaxonomyItem(id, rank, author, status, modified, acceptednameusageid, nameaccordingto, name, parentId, true);
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"sql Error", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getRSItemById(String id) {
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet result = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, nameaccordingto, parentnameusageid, name from taxon where taxonid = ?";
            result = pool.selectPrestatement(query, id);
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (ConnectionPoolException e) {
            this.logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return result;
    }
}

