/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.itis;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.itis.Database;
import org.gcube.data.spd.itis.Utils;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.readers.LocalReader;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id_parent) {
        this.logger.trace((Object)"retrieveTaxonChildsByTaxonId");
        ArrayList<TaxonomyItem> list = new ArrayList<TaxonomyItem>();
        ResultSet results = null;
        Utils util = new Utils();
        Database database = null;
        try {
            try {
                database = new Database();
                database.connect();
                results = database.get("select a.tsn, b.unit_name1, b.unit_name2, b.unit_name3, b.unit_name4, b.taxon_author_id, b.rank_id from taxonomic_units as a NATURAL join taxonomic_units as b where b.unaccept_reason ='' and a.parent_tsn = " + id_parent + " order by b.unit_name1");
                while (results.next()) {
                    String sName = null;
                    String id = results.getString(1);
                    String rank_id = results.getString(7);
                    String citation_id = results.getString(6);
                    if (!results.getString(2).equals("")) {
                        sName = results.getString(2);
                        if (!results.getString(3).equals("")) {
                            sName = sName.concat(" " + results.getString(3));
                            if (!results.getString(4).equals("")) {
                                sName = sName.concat(" " + results.getString(4));
                                if (!results.getString(5).equals("")) {
                                    sName = sName.concat(" " + results.getString(5));
                                }
                            }
                        }
                    }
                    TaxonomyItem tax = new TaxonomyItem(String.valueOf(id));
                    tax.setScientificName(sName);
                    tax.setRank(util.getInfoFromId(rank_id, "rank"));
                    tax.setParent(null);
                    tax.setCitation(util.getInfoFromId(citation_id, "author"));
                    list.add(tax);
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"SQL Error", (Throwable)e);
                try {
                    if (results != null) {
                        results.close();
                    }
                    database.shutDown();
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                this.logger.error((Object)"SQL Error", (Throwable)ex);
            }
        }
        return list;
    }

    public void searchByCommonName(String commonName, ObjectWriter<TaxonomyItem> writer, Property ... properties) {
        this.logger.trace((Object)("retrieveTaxaByCommonName " + commonName));
        ResultSet rs = null;
        Utils util = new Utils();
        Database database = new Database();
        if (database.connect()) {
            try {
                try {
                    rs = database.get("select distinct(a.tsn) from vernaculars as a NATURAL join taxonomic_units as b where UPPER(vernacular_name) like UPPER('%" + commonName + "%') and b.unaccept_reason =''");
                    while (rs.next()) {
                        String id = rs.getString(1);
                        util.retrieveTaxa(writer, id, "common name");
                    }
                }
                catch (SQLException e) {
                    this.logger.error((Object)"SQL Error", (Throwable)e);
                    writer.close();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        database.shutDown();
                    }
                    catch (SQLException ex) {
                        this.logger.error((Object)"SQL Error", (Throwable)ex);
                    }
                }
            }
            finally {
                writer.close();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    database.shutDown();
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        } else {
            this.logger.trace((Object)"No database connection");
        }
    }

    public void searchByScientificName(String scientificName, ObjectWriter<TaxonomyItem> writer, Property ... properties) {
        Utils util = new Utils();
        try {
            this.logger.trace((Object)("retrieveTaxaByScientificName " + scientificName));
            util.retrieveTaxa(writer, scientificName, "scientific name");
            this.logger.trace((Object)("retrieveTaxaByScientificName finished for " + scientificName + " in ITIS"));
        }
        finally {
            writer.close();
        }
    }

    /*
     * Exception decompiling
     */
    public void retrieveTaxonByIds(LocalReader<String> ids, ObjectWriter<TaxonomyItem> writer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[WHILELOOP]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

