/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.itis;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.itis.Database;
import org.gcube.data.spd.itis.ItisPlugin;
import org.gcube.data.spd.plugin.fwk.model.CommonName;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.model.Taxon;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class Utils {
    static GCUBELog logger = new GCUBELog(Utils.class);
    static File tempFolder = null;
    final String urlDump = "http://www.itis.gov/downloads/itisMySQLTables.tar.gz";
    final String zipFileName = "itisMySQLTables.tar.gz";
    final String fileDump = "dropcreateloaditis.sql";

    public void search(String id, ObjectWriter<ResultItem> writer, String type) {
        ResultSet rs1 = null;
        String tsn = null;
        String completeName = null;
        Database database = new Database();
        if (database.connect()) {
            try {
                try {
                    if (type.equals("common name")) {
                        tsn = id;
                        rs1 = database.get("select completename from longnames where tsn = " + tsn);
                    } else if (type.equals("scientific name")) {
                        String scientificName = id;
                        rs1 = database.get("select a.tsn, a.completename from longnames as a join taxonomic_units as b on a.tsn = b.tsn where UPPER(a.completename) like UPPER('%" + scientificName + "%') and b.unaccept_reason =''");
                    } else if (type.equals("synonym")) {
                        tsn = id;
                        rs1 = database.get("select b.tsn, b.completename from synonym_links as a join longnames as b on a.tsn = b.tsn where a.tsn_accepted = " + tsn);
                    }
                    while (rs1.next()) {
                        if (type.equals("common name")) {
                            completeName = rs1.getString(1);
                        } else if (type.equals("scientific name")) {
                            tsn = rs1.getString(1);
                            completeName = rs1.getString(2);
                        } else if (type.equals("synonym")) {
                            tsn = rs1.getString(1);
                            completeName = rs1.getString(2);
                        }
                        this.searchByTsn(tsn, writer, completeName, type, id);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"SQL Error", (Throwable)e);
                    try {
                        if (rs1 != null) {
                            rs1.close();
                        }
                        database.shutDown();
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"SQL Error", (Throwable)ex);
                    }
                }
            }
            finally {
                try {
                    if (rs1 != null) {
                        rs1.close();
                    }
                    database.shutDown();
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        } else {
            logger.error((Object)"No connection");
        }
    }

    public void searchByTsn(String tsn, ObjectWriter<ResultItem> writer, String completeName, String type, String id) {
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        Database database = new Database();
        if (database.connect()) {
            try {
                try {
                    rs2 = database.get("select a.source, a.version, a.source_id from other_sources as a join reference_links as b on b.doc_id_prefix = a.source_id_prefix and b.documentation_id = a.source_id and b.tsn = " + tsn);
                    while (rs2.next()) {
                        String source = rs2.getString(1);
                        String version = rs2.getString(2);
                        String id_source = rs2.getString(3);
                        ResultItem ri = new ResultItem(tsn, completeName);
                        DataSet dataSet = new DataSet(id_source);
                        dataSet.setName(String.valueOf(source) + " " + version);
                        DataProvider dp = new DataProvider("ITIS");
                        dp.setName("The Integrated Taxonomic Information System (ITIS)");
                        dataSet.setDataProvider(dp);
                        ri.setDataSet(dataSet);
                        ri.setCommonNames(this.getCommonNameFromId(tsn));
                        if (type.equals("synonym")) {
                            ri.setParent(this.getHierarchyFromId(id));
                            rs3 = database.get("select taxon_author_id, rank_id from taxonomic_units where tsn = " + id);
                        } else {
                            ri.setParent(this.getHierarchyFromId(tsn));
                            rs3 = database.get("select taxon_author_id, rank_id from taxonomic_units where tsn = " + tsn);
                        }
                        if (rs3.next()) {
                            ri.setCitation(this.getInfoFromId(rs3.getString(1), "author"));
                            ri.setRank(this.getInfoFromId(rs3.getString(2), "rank"));
                            Calendar now = Calendar.getInstance();
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            String credits = "Retrieved " + format.format(now.getTime()) + ", from the Integrated Taxonomic Information System (ITIS) (http://www.itis.gov).";
                            ri.setCredits(credits);
                        }
                        writer.put((Object)ri);
                    }
                }
                catch (SQLException e) {
                    logger.trace((Object)"Failed to make connection in search!");
                    try {
                        if (rs2 != null) {
                            rs2.close();
                        }
                        if (rs3 != null) {
                            rs3.close();
                        }
                        database.shutDown();
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"SQL Error", (Throwable)ex);
                    }
                }
            }
            finally {
                try {
                    if (rs2 != null) {
                        rs2.close();
                    }
                    if (rs3 != null) {
                        rs3.close();
                    }
                    database.shutDown();
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        } else {
            logger.error((Object)"No database connection");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Taxon getHierarchyFromId(String id) {
        ResultSet rs = null;
        Taxon b = null;
        Database database = new Database();
        if (database.connect()) {
            try {
                try {
                    rs = database.get("select a.parent_tsn, b.unit_name1, b.unit_name2, b.unit_name3, b.unit_name4, b.taxon_author_id, b.rank_id from taxonomic_units as a join taxonomic_units as b on a.parent_tsn = b.tsn and a.tsn = " + id);
                    if (!rs.next()) return b;
                    String parent_id = rs.getString(1);
                    String rank_id = rs.getString(7);
                    String citation_id = rs.getString(6);
                    if (rs.getString(2).equals("")) return b;
                    String sName = rs.getString(2);
                    if (!rs.getString(3).equals("")) {
                        sName = sName.concat(" " + rs.getString(3));
                        if (!rs.getString(4).equals("")) {
                            sName = sName.concat(" " + rs.getString(4));
                            if (!rs.getString(5).equals("")) {
                                sName = sName.concat(" " + rs.getString(5));
                            }
                        }
                    }
                    b = new Taxon(parent_id);
                    if (!rank_id.equals("0")) {
                        b.setRank(this.getInfoFromId(rank_id, "rank"));
                    }
                    if (!citation_id.equals("0")) {
                        b.setCitation(this.getInfoFromId(citation_id, "author"));
                    }
                    b.setScientificName(sName);
                    if (parent_id.equals("0")) return b;
                    b.setParent(this.getHierarchyFromId(parent_id));
                    return b;
                }
                catch (SQLException e) {
                    logger.error((Object)"SQL Error", (Throwable)e);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        database.shutDown();
                        return b;
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"SQL Error", (Throwable)ex);
                    }
                }
                return b;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    database.shutDown();
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        }
        logger.trace((Object)"No database connection");
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TaxonomyItem getHierarchyTaxFromId(String id) {
        ResultSet rs = null;
        TaxonomyItem b = null;
        Database database = new Database();
        if (database.connect()) {
            try {
                try {
                    rs = database.get("select a.parent_tsn, b.unit_name1, b.unit_name2, b.unit_name3, b.unit_name4, b.taxon_author_id, b.rank_id, a.update_date from taxonomic_units as a join taxonomic_units as b on a.parent_tsn = b.tsn and a.tsn = " + id);
                    if (!rs.next()) return b;
                    String parent_id = rs.getString(1);
                    String rank_id = rs.getString(7);
                    String citation_id = rs.getString(6);
                    if (rs.getString(2).equals("")) return b;
                    String sName = rs.getString(2);
                    if (!rs.getString(3).equals("")) {
                        sName = sName.concat(" " + rs.getString(3));
                        if (!rs.getString(4).equals("")) {
                            sName = sName.concat(" " + rs.getString(4));
                            if (!rs.getString(5).equals("")) {
                                sName = sName.concat(" " + rs.getString(5));
                            }
                        }
                    }
                    b = new TaxonomyItem(parent_id);
                    if (!rank_id.equals("0")) {
                        b.setRank(this.getInfoFromId(rank_id, "rank"));
                    }
                    if (!citation_id.equals("0")) {
                        b.setCitation(this.getInfoFromId(citation_id, "author"));
                    }
                    b.setScientificName(sName);
                    if (!parent_id.equals("0")) {
                        b.setParent(this.getHierarchyTaxFromId(parent_id));
                    }
                    b.setCommonNames(this.getCommonNameFromId(id));
                    b.setStatus(new TaxonomyStatus(TaxonomyStatus.Status.ACCEPTED));
                    b.setModified(this.getCalendar(rs.getString(8)));
                    return b;
                }
                catch (SQLException e) {
                    logger.error((Object)"SQL Error", (Throwable)e);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        database.shutDown();
                        return b;
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"SQL Error", (Throwable)ex);
                    }
                }
                return b;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    database.shutDown();
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        }
        logger.trace((Object)"No database connection");
        return b;
    }

    public List<CommonName> getCommonNameFromId(String id) {
        ArrayList<CommonName> commonNames = new ArrayList<CommonName>();
        ResultSet results = null;
        Database database = new Database();
        if (database.connect()) {
            try {
                try {
                    results = database.get("select vernacular_name, language from vernaculars where tsn = " + id);
                    while (results.next()) {
                        String name = results.getString(1);
                        String language = results.getString(2);
                        CommonName commonName = new CommonName(language, name);
                        commonNames.add(commonName);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"SQL Error", (Throwable)e);
                    try {
                        if (results != null) {
                            results.close();
                        }
                        database.shutDown();
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"SQL Error", (Throwable)ex);
                    }
                }
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                    database.shutDown();
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        } else {
            logger.trace((Object)"No database connection");
        }
        return commonNames;
    }

    public String getInfoFromId(String id, String type) {
        ResultSet res = null;
        String info = null;
        Database database = new Database();
        if (database.connect()) {
            try {
                if (type.equals("author")) {
                    res = database.get("select taxon_author from taxon_authors_lkp where taxon_author_id = " + id);
                } else if (type.equals("rank")) {
                    res = database.get("select rank_name from taxon_unit_types where rank_id = " + id);
                }
                if (res.next()) {
                    info = res.getString(1);
                }
                return "";
            }
            catch (SQLException e) {
                logger.error((Object)"SQL Error", (Throwable)e);
            }
            finally {
                try {
                    if (res != null) {
                        res.close();
                    }
                    database.shutDown();
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        } else {
            logger.trace((Object)"No database connection");
        }
        return info;
    }

    public void update() throws IOException {
        block10: {
            try {
                URL url = new URL("http://www.itis.gov/downloads/itisMySQLTables.tar.gz");
                tempFolder = File.createTempFile("itis-folder", "");
                tempFolder.delete();
                tempFolder.mkdir();
                String folder = null;
                if (this.downloadFromUrl(url, tempFolder + "/" + "itisMySQLTables.tar.gz")) {
                    Runtime rt1 = Runtime.getRuntime();
                    Process runtimeProcess1 = null;
                    logger.trace((Object)("tar xzvf " + tempFolder + "/" + "itisMySQLTables.tar.gz" + " -C " + tempFolder));
                    runtimeProcess1 = rt1.exec("tar xzvf " + tempFolder + "/" + "itisMySQLTables.tar.gz" + " -C " + tempFolder);
                    runtimeProcess1.waitFor();
                    File f = new File(tempFolder + "/" + "itisMySQLTables.tar.gz");
                    if (f.exists()) {
                        f.delete();
                    }
                    Process p = Runtime.getRuntime().exec("ls " + tempFolder);
                    BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = null;
                    line = in.readLine();
                    if (line != null) {
                        folder = String.valueOf(line) + "/";
                    }
                    if (folder != null) {
                        String fileContent = this.getFileContent(tempFolder + "/" + folder + "dropcreateloaditis.sql").replace("LOAD DATA LOCAL INFILE '", "LOAD DATA LOCAL INFILE '" + tempFolder + "/" + folder);
                        this.setFileContent(tempFolder + "/" + folder + "dropcreateloaditis.sql", fileContent);
                        Runtime rt = Runtime.getRuntime();
                        logger.trace((Object)("mysql -h " + ItisPlugin.hostName + " -u " + ItisPlugin.user + " --password=" + ItisPlugin.password + " --enable-local-infile < " + tempFolder + "/" + folder + "dropcreateloaditis.sql"));
                        String[] executeCmd = new String[]{"/bin/sh", "-c", "mysql -h " + ItisPlugin.hostName + " -u " + ItisPlugin.user + " --password=" + ItisPlugin.password + " --enable-local-infile < " + tempFolder + "/" + folder + "dropcreateloaditis.sql"};
                        Process runtimeProcess = null;
                        try {
                            runtimeProcess = rt.exec(executeCmd);
                            runtimeProcess.waitFor();
                            int processComplete = runtimeProcess.waitFor();
                            if (processComplete == 0) {
                                logger.trace((Object)"Database created successfully");
                            } else {
                                logger.trace((Object)"Could not create the database");
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)this.loadStream(runtimeProcess.getErrorStream()), (Throwable)ex);
                        }
                    }
                    this.emptyFolder(tempFolder);
                    break block10;
                }
                logger.warn((Object)"Download failed");
            }
            catch (Exception e) {
                logger.error((Object)"General Error", (Throwable)e);
            }
        }
    }

    public void emptyFolder(File f) {
        if (f.exists()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                if (c.isDirectory()) {
                    this.emptyFolder(c);
                }
                c.delete();
                ++n2;
            }
            f.delete();
        }
    }

    public boolean downloadFromUrl(URL url, String localFilename) throws IOException {
        boolean flag = false;
        logger.trace((Object)("Downloading " + localFilename));
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int len;
            URLConnection urlConn = url.openConnection();
            is = urlConn.getInputStream();
            fos = new FileOutputStream(localFilename);
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            flag = true;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        return flag;
    }

    public String getFileContent(String path) throws FileNotFoundException, IOException {
        String content = "";
        BufferedReader br = new BufferedReader(new FileReader(path));
        while (br.ready()) {
            content = String.valueOf(content) + "\n" + br.readLine();
        }
        br.close();
        return content;
    }

    public void setFileContent(String string, String content) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(string);
        fos.write(content.getBytes());
        fos.close();
    }

    private String loadStream(InputStream in) throws IOException {
        int ptr = 0;
        in = new BufferedInputStream(in);
        StringBuffer buffer = new StringBuffer();
        while ((ptr = in.read()) != -1) {
            buffer.append((char)ptr);
        }
        return buffer.toString();
    }

    public Calendar getCalendar(String date) {
        Calendar cal = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (!date.equals("")) {
            try {
                Date d = new Date(sdf.parse(date).getTime());
                cal = Calendar.getInstance();
                cal.setTime(d);
            }
            catch (ParseException e) {
                logger.error((Object)"ParseException", (Throwable)e);
            }
        } else {
            cal = Calendar.getInstance();
        }
        return cal;
    }

    public void retrieveTaxa(ObjectWriter<TaxonomyItem> writer, String name, String type) {
        ResultSet results = null;
        Database database = new Database();
        if (database.connect()) {
            try {
                try {
                    if (type.equals("common name")) {
                        String tsn = name;
                        results = database.get("select a.tsn, a.completename, b.taxon_author_id, b.rank_id, b.update_date from longnames as a NATURAL join taxonomic_units as b where a.tsn = " + tsn);
                    } else {
                        results = database.get("select a.tsn, a.completename, b.taxon_author_id, b.rank_id, b.update_date from longnames as a NATURAL join taxonomic_units as b where UPPER(a.completename) like UPPER('%" + name + "%') and b.unaccept_reason =''");
                    }
                    while (results.next()) {
                        String id = results.getString(1);
                        String sName = results.getString(2);
                        String citation_id = results.getString(3);
                        String rank_id = results.getString(4);
                        TaxonomyItem tax = new TaxonomyItem(String.valueOf(id));
                        tax.setScientificName(sName);
                        tax.setRank(this.getInfoFromId(rank_id, "rank"));
                        tax.setParent(this.getHierarchyTaxFromId(id));
                        tax.setCitation(this.getInfoFromId(citation_id, "author"));
                        tax.setCommonNames(this.getCommonNameFromId(id));
                        tax.setModified(this.getCalendar(results.getString(5)));
                        tax.setStatus(new TaxonomyStatus(TaxonomyStatus.Status.ACCEPTED));
                        writer.put((Object)tax);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"SQL Error", (Throwable)e);
                    try {
                        if (results != null) {
                            results.close();
                        }
                        database.shutDown();
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"SQL Error", (Throwable)ex);
                    }
                }
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                    database.shutDown();
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        } else {
            logger.trace((Object)"No database connection");
        }
    }
}

