/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi.capabilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.Database;
import org.gcube.data.spd.ncbi.Utils;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id) {
        this.logger.trace((Object)("retrieveTaxonChildsByTaxonId " + id));
        ArrayList<TaxonomyItem> list = new ArrayList<TaxonomyItem>();
        ResultSet rs = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            this.logger.trace((Object)("select a.tax_id, b.name_txt, a.rank from nodes as a NATURAL JOIN names as b where a.parent_tax_id = " + id));
            rs = database.get("select a.tax_id, b.name_txt, a.rank, b.name_class from nodes as a NATURAL JOIN names as b where a.parent_tax_id = " + id);
            while (rs.next()) {
                int id_res = rs.getInt(1);
                String ScName = rs.getString(2);
                String rank = rs.getString(3);
                String status = rs.getString(3);
                TaxonomyItem tax = new TaxonomyItem(id_res + "");
                tax.setScientificName(ScName);
                tax.setCitation(Utils.getCitation(Integer.parseInt(id_res + "")));
                tax.setStatus(this.setTaxonomicStatus(status));
                tax.setCommonNames(Utils.getCommonNames(id_res));
                if (rank.equals("no rank")) {
                    tax.setRank(null);
                } else {
                    tax.setRank(rank);
                }
                list.add(tax);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
            catch (Exception e) {
                this.logger.error((Object)"General Error", (Throwable)e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByCommonName(String name, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
        this.logger.trace((Object)("Retrive Taxa By Common Name " + name));
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs1 = database.get("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + name + "%')");
            while (rs1.next()) {
                int id_cm = rs1.getInt(1);
                rs2 = database.get("select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id_cm);
                if (!rs2.next()) continue;
                int id = rs2.getInt(1);
                String ScName = rs2.getString(2);
                String rank = rs2.getString(3);
                String idParent = rs2.getString(4);
                String status = rs2.getString(5);
                TaxonomyItem tax = new TaxonomyItem(id + "");
                tax.setScientificName(ScName);
                tax.setCitation(Utils.getCitation(id));
                tax.setStatus(this.setTaxonomicStatus(status));
                tax.setCommonNames(Utils.getCommonNames(id));
                if (rank.equals("no rank")) {
                    tax.setRank(null);
                } else {
                    tax.setRank(rank);
                }
                if (!idParent.equals("1")) {
                    tax.setParent(this.findTaxonomy(Integer.parseInt(idParent)));
                }
                writer.put((Object)tax);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            writer.close();
            this.logger.trace((Object)"close");
            try {
                if (rs1 != null) {
                    rs1.close();
                }
                if (rs2 != null) {
                    rs2.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String name, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
        this.logger.trace((Object)("Retrive Taxa By Scientific Name " + name));
        ResultSet rs = null;
        ResultSet rs1 = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs1 = database.get("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + name + "%')");
            while (rs1.next()) {
                int id = rs1.getInt(1);
                rs = database.get("select b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id);
                if (!rs.next()) continue;
                String ScName = rs.getString(1);
                String rank = rs.getString(2);
                String idParent = rs.getString(3);
                String status = rs.getString(4);
                TaxonomyItem tax = new TaxonomyItem(id + "");
                tax.setScientificName(ScName);
                tax.setCitation(Utils.getCitation(id));
                tax.setStatus(this.setTaxonomicStatus(status));
                tax.setCommonNames(Utils.getCommonNames(id));
                if (rank.equals("no rank")) {
                    tax.setRank(null);
                } else {
                    tax.setRank(rank);
                }
                if (!idParent.equals("1")) {
                    tax.setParent(this.findTaxonomy(Integer.parseInt(idParent)));
                }
                writer.put((Object)tax);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            writer.close();
            this.logger.trace((Object)"close");
            try {
                if (rs != null) {
                    rs.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {
        ResultSet rs = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            while (ids.hasNext()) {
                String id = ids.next();
                this.logger.trace((Object)("Retrive taxon by id " + id));
                rs = database.get("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id = " + id);
                while (rs.next()) {
                    String ScName = rs.getString(1);
                    String rank = rs.getString(2);
                    String idParent = rs.getString(3);
                    TaxonomyItem tax = new TaxonomyItem(id + "");
                    tax.setScientificName(ScName);
                    tax.setCitation(Utils.getCitation(Integer.parseInt(id)));
                    tax.setStatus(new TaxonomyStatus(TaxonomyStatus.Status.ACCEPTED, "accepted"));
                    tax.setCommonNames(Utils.getCommonNames(Integer.parseInt(id)));
                    if (rank.equals("no rank")) {
                        tax.setRank(null);
                    } else {
                        tax.setRank(rank);
                    }
                    if (!idParent.equals("1")) {
                        tax.setParent(this.findTaxonomy(Integer.parseInt(idParent)));
                    }
                    writer.put((Object)tax);
                }
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            writer.close();
            this.logger.trace((Object)"close");
            try {
                if (rs != null) {
                    rs.close();
                }
                database.shutDown();
            }
            catch (SQLException ex) {
                this.logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
    }

    private TaxonomyStatus setTaxonomicStatus(String status) {
        TaxonomyStatus tax = status.equals("scientific name") ? new TaxonomyStatus(TaxonomyStatus.Status.ACCEPTED, status) : new TaxonomyStatus(TaxonomyStatus.Status.UNKNOWN, status);
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaxonomyItem findTaxonomy(Integer id) {
        ResultSet rs = null;
        TaxonomyItem t = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs = database.get("select a.parent_tax_id, b.name_txt, a.rank, b.name_class from nodes as a NATURAL JOIN names as b where a.tax_id = " + id + " and b.name_class = 'scientific name'");
            if (rs.next()) {
                int id_parent = rs.getInt(1);
                String rank = rs.getString(3);
                String status = rs.getString(4);
                t = new TaxonomyItem(id + "");
                t.setStatus(this.setTaxonomicStatus(status));
                t.setCommonNames(Utils.getCommonNames(id));
                t.setRank(rank);
                t.setScientificName(rs.getString(2));
                t.setCitation(Utils.getCitation(id));
                if (id_parent != 1 && !rank.equals("kingdom")) {
                    t.setParent(this.findTaxonomy(id_parent));
                }
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"SQLException", (Throwable)e);
            }
            database.shutDown();
        }
        return t;
    }
}

