package org.gcube.data.spd.ncbi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.model.CommonName;
import org.gcube.data.spd.plugin.fwk.model.Taxon;


public class Utils {

	
	static GCUBELog logger = new GCUBELog(Utils.class);

	//metod called by CreateDBThread
	public static void createDB() throws SQLException, IOException {

		logger.trace("Creating tables...");

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();

			BufferedReader br = new BufferedReader(new InputStreamReader(NcbiPlugin.class.getResourceAsStream(NcbiPlugin.fileDump)));
			String line;
			while ((line = br.readLine()) != null) {
				
				if (database.update(line) != true)
					logger.warn("error in: '" + line + "'");
			}
			logger.trace("Table created successfully");		
		}
		finally {
				database.shutDown();
		}
	}


	public static String getCitation(int id) {

		StringBuilder cit = new StringBuilder();
		ResultSet rs = null;
		ResultSet rs1 = null;

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
			//			logger.trace("select cit_id from citation where tax_id = " + id );
			rs = database.get("select cit_id from citation where tax_id = " + id );

			while(rs.next()) {	
				int cit_id = rs.getInt(1);
				
				rs1 = database.get("select cit_key from citations where cit_id = " + cit_id );

				while(rs1.next()) {
					if (cit.length()!= 0)
						cit.append(", ");
					cit.append(rs1.getString(1));
				}				
			}
		}
		catch (SQLException sqlExcept) {
			logger.error("sql Error",sqlExcept);
		}finally {

			try {
				if (rs != null) 
					rs.close();
				if (rs1 != null) 
					rs1.close();

			} catch (SQLException e) {
				logger.error("SQLException", e);
			}
			database.shutDown();
		} 
		return cit.toString();	
	}


	//find taxonomy 
	public static Taxon findTax(Integer id_record) {		

		ResultSet rs = null;
		Taxon t = null;
		
		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
			//			logger.trace("select a.parent_tax_id, b.name_txt, a.rank from nodes as a NATURAL JOIN names as b where a.tax_id = " + id_record + " and b.name_class = 'scientific name'");
			rs = database.get("select a.parent_tax_id, b.name_txt, a.rank from nodes as a NATURAL JOIN names as b where a.tax_id = " + id_record + " and b.name_class = 'scientific name'");
			if(rs.next())
			{	        	
				int id_parent = rs.getInt(1);
				String rank = rs.getString(3);
				t = new Taxon(id_record+"");

				t.setRank(rank);

				t.setScientificName(rs.getString(2));
				t.setCitation(getCitation(id_record));     

				if  ((id_parent != 1) && !(rank.equals("kingdom")))		
					t.setParent(findTax(id_parent));	
			}
		}
		catch (SQLException sqlExcept) {
			logger.error("sql Error",sqlExcept);
		}finally {
			try {
				if (rs != null) 
					rs.close();
			} catch (SQLException e) {
				logger.error("SQLException", e);
			}
			database.shutDown();
		}   
		return t;		
	}



	public static List<CommonName> getCommonNames(int id) {

		List<CommonName> commonNames = new ArrayList<CommonName> ();
		String language = "English";

		ResultSet rs = null;

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
			//			logger.trace("select name_txt from names where name_class = 'common name' and tax_id = " + id);
			rs = database.get("select name_txt from names where name_class = 'common name' and tax_id = " + id);

			while(rs.next()) {	
				String name = rs.getString(1);
				CommonName a = new CommonName(language,name);
				commonNames.add(a);
			}
		}
		catch (SQLException sqlExcept) {
			logger.error("sql Error", sqlExcept);
		}catch (Throwable e) {
			logger.error("general Error", e);

		}finally {
			try {
				if (rs != null) 
					rs.close();
			} catch (SQLException e) {
				logger.error("SQLException", e);
			}
			database.shutDown();
		} 
		return commonNames;
	}


}

////Create NCBI db
//class CreateDBThread extends Thread {
//
//	static GCUBELog logger = new GCUBELog(CreateDBThread.class);
//
//	CreateDBThread() {
//		super("Thread");
//		start(); // Start the thread
//	}
//
//	// This is the entry point for the child threads
//	public void run() {
//		try {
//			Utils util = new Utils();
//			util.createDB();
//		} catch (IOException e) {
//			logger.error("IO Error", e);
//		} catch (SQLException e) {
//			logger.error("sql Error", e);
//		}
//	} 
//}
