package org.gcube.data.spd.ncbi.capabilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.Database;
import org.gcube.data.spd.ncbi.Utils;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;




public class ClassificationCapabilityImpl extends ClassificationCapability {

	GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

	@Override
	public Set<Properties> getSupportedProperties() {
		return Collections.emptySet();
	}



	@Override
	public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id) {
		logger.trace("retrieveTaxonChildsByTaxonId " + id);
		List<TaxonomyItem> list = new ArrayList<TaxonomyItem>(); 		
		ResultSet rs = null;
		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
			logger.trace("select a.tax_id, b.name_txt, a.rank from nodes as a NATURAL JOIN names as b where a.parent_tax_id = " + id);
			rs = database.get("select a.tax_id, b.name_txt, a.rank, b.name_class from nodes as a NATURAL JOIN names as b where a.parent_tax_id = " + id);

			while(rs.next()){	
				//				logger.trace(rs.getInt(1) + " " + rs.getString(2));
				int id_res = rs.getInt(1);
				String ScName = rs.getString(2);
				String rank = rs.getString(3);
				String status = rs.getString(3);

				TaxonomyItem tax = new TaxonomyItem(id_res + "");
				tax.setScientificName(ScName);	    		
				tax.setCitation(Utils.getCitation(Integer.parseInt(id_res+"")));	 
				//				logger.trace(NcbiPlugin.getCitation(Integer.parseInt(id_res+"")));

				tax.setStatus(setTaxonomicStatus(status));
				tax.setCommonNames(Utils.getCommonNames(id_res));


				if (rank.equals("no rank"))
					tax.setRank(null);
				else					
					tax.setRank(rank);
				
				//don't print taxonomy
//				if (!(id.equals("1"))){	
//					tax.setParent(findTaxonomy(Integer.parseInt(id_res+"")));		  
//				}

				list.add(tax); 
			}

		}
		catch (SQLException sqlExcept){        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e){
			logger.error("general Error", e);
		} finally {

			try {

				if (rs != null) 
					rs.close();

				database.shutDown();
//				logger.trace("close conn");

			} catch (SQLException ex) {
				logger.error("sql Error", ex);

			} catch (Exception e) {
				logger.error("General Error", e);
			}
		}

		return list;
	}




	@Override
	public void searchByCommonName(String name,
			ObjectWriter<TaxonomyItem> writer, Property... arg2) {
		logger.trace("Retrive Taxa By Common Name " + name);
		ResultSet rs1 = null;
		ResultSet rs2 = null;
		
		Database database = null;  
		
		try {
			database = new Database();  			
			database.connect();
			//			logger.trace("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + name + "%')");
			rs1 = database.get("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + name + "%')");

			while(rs1.next()) {	     
				int id_cm = rs1.getInt(1);

				//				logger.trace("select a.tax_id, b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id_cm );
				rs2 = database.get("select a.tax_id, b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id_cm );

				if(rs2.next()) {	
					int id = rs2.getInt(1);
					String ScName = rs2.getString(2);
					String rank = rs2.getString(3);
					String idParent = rs2.getString(4);
					String status = rs2.getString(5);

					TaxonomyItem tax = new TaxonomyItem(id + "");
					tax.setScientificName(ScName);            	
					tax.setCitation(Utils.getCitation(id));

					tax.setStatus(setTaxonomicStatus(status));
					tax.setCommonNames(Utils.getCommonNames(id));

					if (rank.equals("no rank"))
						tax.setRank(null);
					else					
						tax.setRank(rank);

					if (!(idParent.equals("1"))) {	
						//						logger.trace("findTaxonomy " + idParent);
						tax.setParent(findTaxonomy(Integer.parseInt(idParent)));	            	      	
					}

					writer.put(tax);
				}
			}
		}
		catch (SQLException sqlExcept) {        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		} finally {
			writer.close();	
			logger.trace("close");
			try {
				if (rs1 != null) 
					rs1.close();
				if (rs2 != null) 
					rs2.close();

				database.shutDown();

			} catch (SQLException ex) {
				logger.error("sql Error", ex);

			}
		}

	}



	@Override
	public void searchByScientificName(String name,
			ObjectWriter<TaxonomyItem> writer, Property... arg2) {

		logger.trace("Retrive Taxa By Scientific Name " + name);
		ResultSet rs = null ;
		ResultSet rs1 = null ;

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
//			logger.trace("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + name + "%')");
			rs1 = database.get("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + name + "%')");

			while(rs1.next()) {	
				String ScName;
				String rank;
				String idParent;
				String status;
				
				int id = rs1.getInt(1);
				
				rs = database.get("select b.name_txt, a.rank, a.parent_tax_id, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id );

				if(rs.next()) {

					ScName = rs.getString(1);
					rank = rs.getString(2);
					idParent = rs.getString(3);
					status = rs.getString(4);

					TaxonomyItem tax = new TaxonomyItem(id + "");
					tax.setScientificName(ScName);            	
					tax.setCitation(Utils.getCitation(id));

					tax.setStatus(setTaxonomicStatus(status));
					tax.setCommonNames(Utils.getCommonNames(id));

					if (rank.equals("no rank"))
						tax.setRank(null);
					else
						tax.setRank(rank);

					if (!(idParent.equals("1"))) {	
						//					logger.trace("findTaxonomy " + idParent);
						tax.setParent(findTaxonomy(Integer.parseInt(idParent)));	            	      	
					}
					writer.put(tax);
				}
			}
		}

		catch (SQLException sqlExcept) {        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		} finally {
			writer.close();	
			logger.trace("close");
			try {
				if (rs != null) 
					rs.close();

				database.shutDown();

			} catch (SQLException ex) {
				logger.error("sql Error", ex);

			}
		}
		//		writer.close();	

	}



	@Override
	public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {

		ResultSet rs = null ;
		Database database = null;  
		
		try {
			database = new Database();  			
			database.connect();
			String id;
			while(ids.hasNext()) {
				
				String ScName;
				String rank;
				String idParent;
				
				id = ids.next(); 
				logger.trace("Retrive taxon by id " + id);
				//			plugin.createConnection();

				//			logger.trace("select a.tax_id, b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and UPPER(b.name_txt) like UPPER('%" + name + "%')");      	
				rs = database.get("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id = " + id );

				while(rs.next()) {	        		

					ScName = rs.getString(1);
					rank = rs.getString(2);
					idParent = rs.getString(3);

					TaxonomyItem tax = new TaxonomyItem(id + "");
					tax.setScientificName(ScName);            	
					tax.setCitation(Utils.getCitation(Integer.parseInt(id)));
					
					tax.setStatus(new TaxonomyStatus(TaxonomyStatus.Status.ACCEPTED, "accepted"));
					tax.setCommonNames(Utils.getCommonNames(Integer.parseInt(id)));

					if (rank.equals("no rank"))
						tax.setRank(null);
					else
						tax.setRank(rank);

					if (!(idParent.equals("1"))) {	
						//					logger.trace("findTaxonomy " + idParent);
						tax.setParent(findTaxonomy(Integer.parseInt(idParent)));	            	      	
					}
					writer.put(tax);
				}
			}
		}
		catch (SQLException sqlExcept) {        	
			logger.error("sql Error", sqlExcept);
		}
		catch (Throwable e) {
			logger.error("general Error", e);
		} finally {
			writer.close();	
			logger.trace("close");
			try {
				if (rs != null) 
					rs.close();

				database.shutDown();

			} catch (SQLException ex) {
				logger.error("sql Error", ex);

			}
		}

	}

	private TaxonomyStatus setTaxonomicStatus(String status) {
		TaxonomyStatus tax;
		if (status.equals("scientific name"))
			tax= new TaxonomyStatus(TaxonomyStatus.Status.ACCEPTED, status);
		else
			tax= new TaxonomyStatus(TaxonomyStatus.Status.UNKNOWN, status);
		return tax;
	}



	//find taxonomy item
	protected TaxonomyItem findTaxonomy(Integer id) {		

		ResultSet rs = null;
		TaxonomyItem t = null;

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
			//			logger.trace("select a.parent_tax_id, b.name_txt, a.rank from nodes as a NATURAL JOIN names as b where a.tax_id = " + id_record + " and b.name_class = 'scientific name'");
			rs = database.get("select a.parent_tax_id, b.name_txt, a.rank, b.name_class from nodes as a NATURAL JOIN names as b where a.tax_id = " + id + " and b.name_class = 'scientific name'");
			if(rs.next())
			{	   
				int id_parent = rs.getInt(1);
				String rank = rs.getString(3);
				String status = rs.getString(4);
				t = new TaxonomyItem(id+"");

				t.setStatus(setTaxonomicStatus(status));
				t.setCommonNames(Utils.getCommonNames(id));
				t.setRank(rank);
				t.setScientificName(rs.getString(2));
				t.setCitation(Utils.getCitation(id)); 
				if  ((id_parent != 1) && !(rank.equals("kingdom")))	
					t.setParent(findTaxonomy(id_parent));	
			}
		}
		catch (SQLException sqlExcept) {
			logger.error("sql Error",sqlExcept);
		}finally {

			try {
				if (rs != null) 
					rs.close();
			} catch (SQLException e) {
				logger.error("SQLException", e);
			}
			database.shutDown();
		}   
		return t;		
	}



}
