package org.gcube.data.spd.ncbi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.capabilities.ClassificationCapabilityImpl;
import org.gcube.data.spd.ncbi.capabilities.NamesMappingImpl;
import org.gcube.data.spd.ncbi.capabilities.SynonimsCapabilityImpl;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.SynonimsCapability;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;


public class NcbiPlugin extends AbstractPlugin{

	static GCUBELog logger = new GCUBELog(NcbiPlugin.class);

	//POSTGRESQL CONNECTION

	public static String jdbc;
	public static String username;
	public static String password;
	
//	static String jdbc = "jdbc:postgresql://127.0.0.1:5432/ncbi_db";
//	static String password = "";
//	static String username = "postgres";
	//*****************************************

	public static Hashtable<String, String> tables = new Hashtable<String, String>();
	final public static String credits = "GenBank taxonomy database";
	final static String urlDump = "ftp://ftp.ncbi.nih.gov/pub/taxonomy/taxdump.tar.gz";
	final static String zipFileName = "taxdump.tar.gz";
	final static String fileDump = "/ncbi_db.sql";
	final static String names[] = {"nodes", "delnodes", "merged", "citations", "names", "division", "gencode"};
//	final static String [] tables = {"nodes", "delnodes", "merged", "citations", "names", "division", "gencode", "citation"};


	@Override
	public void initialize(GCUBERuntimeResource res) throws Exception {
		for (AccessPoint ap:res.getAccessPoints())
		{		
			//			if (ap.getEntryname().equals("jdbc"))
			//			{
			//				jdbc = ap.getEndpoint();	
			//				username = ap.getUsername();
			//				password = ap.getPassword();
			//			}
		}

		Boolean flag = false;
		for(String s : names){
			if (!(SQLTableExists(s)))
				flag = true;
			break;
		}

		if (flag)
			Utils.createDB();

		new UpdateThread();	

	}

	@Override
	public String getDescription() {
		return ("NCBI Plugin");
	}

	@Override
	public String getRepositoryName() {
		return ("NCBI");
	}

	@SuppressWarnings("serial")
	@Override
	public Set<SearchTypes> getSupportedSearch() {
		return new HashSet<SearchTypes>(){{add(SearchTypes.ScientificName); add(SearchTypes.CommonName);}};
	}

	@SuppressWarnings("serial")
	@Override
	public Set<Capabilities> getSupportedCapabilities() {
		return new HashSet<Capabilities>(){{add(Capabilities.Classification);add(Capabilities.Synonims);add(Capabilities.NamesMapping);}};
	}

	@Override
	public ClassificationCapability getClassificationInterface() {
		return new ClassificationCapabilityImpl();
	}

	@Override
	public SynonimsCapability getSynonimsInterface() {
		return new SynonimsCapabilityImpl();
	}

	@Override
	public NamesMappingCapability getNamesMappingInterface() {
		return new NamesMappingImpl();
	}

	@Override
	public void searchByCommonName(String commonName, ObjectWriter<ResultItem> writer, Property... arg2) {

		logger.trace("searchByCommonName for "+commonName+" in NCBI...");

		ResultSet rs1 = null;
		ResultSet rs2 = null;

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
			//						logger.trace("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + commonName + "%')");
			rs1 = database.get("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + commonName + "%')");

			while(rs1.next()) {	
				int id = rs1.getInt(1);

				//				logger.trace("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id );
				rs2 = database.get("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id );

				if(rs2.next()) {	

					String ScName = rs2.getString(1);
					logger.trace(ScName);
					String rank = rs2.getString(2);
					String idParent = rs2.getString(3);

					ResultItem rs = new ResultItem(Integer.toString(id), ScName);

					rs.setCommonNames(Utils.getCommonNames(id));
					rs.setCredits(credits);

					if (rank.equals("no rank"))
						rs.setRank(null);
					else					
						rs.setRank(rank);

					rs.setCitation(Utils.getCitation(Integer.parseInt(idParent)));

					DataSet dataSet = new DataSet("GenBank");
					dataSet.setName("GenBank taxonomy database");
					DataProvider dp = new DataProvider("GenBank");
					dp.setName("GenBank taxonomy database");
					dataSet.setDataProvider(dp);
					rs.setDataSet(dataSet);

					if (!(idParent.equals("1")))	
						rs.setParent(Utils.findTax(Integer.parseInt(idParent)));	            	      	

					writer.put(rs);
				}
			}

			logger.trace("searchByCommonName finished for "+commonName+" in NCBI");

		}
		catch (SQLException sqlExcept)
		{
			logger.error("sql Error", sqlExcept);
		}catch (Throwable e) {
			logger.error("general Error", e);
		} finally {
			writer.close();
			logger.trace("close");
			try {
				if (rs1 != null) 
					rs1.close();
				if (rs2 != null) 
					rs2.close();
				database.shutDown();
			} catch (SQLException ex) {
				logger.error("sql Error", ex);

			} catch (Exception e) {
				logger.error("General Error", e);
			}
		}

	}


	@Override
	public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Property... properties) {

		logger.trace("searchByScientificName for "+scientificName+" in NCBI...");


		ResultSet rs1 = null;
		ResultSet rs2 = null;

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();

			//						logger.trace("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + commonName + "%')");
			rs1 = database.get("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + scientificName + "%')");

			while(rs1.next()) {	
				int id = rs1.getInt(1);
				//				logger.trace("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id );
				rs2 = database.get("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id );

				if(rs2.next()) {	

					String ScName = rs2.getString(1);
					logger.trace(ScName);
					String rank = rs2.getString(2);
					String idParent = rs2.getString(3);

					ResultItem rs = new ResultItem(Integer.toString(id), ScName);

					rs.setCommonNames(Utils.getCommonNames(id));
					rs.setCredits(credits);

					if (rank.equals("no rank"))
						rs.setRank(null);
					else					
						rs.setRank(rank);

					rs.setCitation(Utils.getCitation(Integer.parseInt(idParent)));

					DataSet dataSet = new DataSet("GenBank");
					dataSet.setName("GenBank taxonomy database");
					DataProvider dp = new DataProvider("GenBank");
					dp.setName("GenBank taxonomy database");
					dataSet.setDataProvider(dp);
					rs.setDataSet(dataSet);

					if (!(idParent.equals("1")))	
						rs.setParent(Utils.findTax(Integer.parseInt(idParent)));	            	      	

					writer.put(rs);
				}
			}

			logger.trace("searchByCommonName finished for "+scientificName+" in NCBI");

		}
		catch (SQLException sqlExcept)
		{
			logger.error("sql Error", sqlExcept);
		}catch (Throwable e) {
			logger.error("general Error", e);
		} finally {
			writer.close();
			logger.trace("close");
			try {
				if (rs1 != null) 
					rs1.close();
				if (rs2 != null) 
					rs2.close();

				shutdown();

			} catch (SQLException ex) {
				logger.error("sql Error", ex);
			} catch (Exception e) {
				logger.error("General Error", e);
			}
		}

	}

	/**
	 * Return true if a table exists
	 */
	public static boolean SQLTableExists(String tableName) {
		boolean exists = false;
		ResultSet rs = null;
		Database database = null;  
		try {
			database = new Database();  			
			database.connect();

			String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";    
			rs = database.get(sqlText);
			if (rs.next())
				exists = true;
			else
				exists = false;

		} catch (SQLException e) {
			logger.error("SQLException", e);
		}finally {

			try {
				if (rs != null) 
					rs.close();					
			} catch (SQLException e) {
				logger.error("SQLException", e);
			}

			database.shutDown();
		} 
		return exists;
	}

}
