/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.data;

import java.io.Serializable;

public class Coordinate
implements Serializable {
    private static final long serialVersionUID = -2357675565732391317L;
    public static final String COORDINATE_SEPARATOR = ":";
    protected double latitude;
    protected double longitude;

    public static Coordinate parse(String value) throws Exception {
        if (value == null || value.length() == 0) {
            return null;
        }
        String[] tokens = value.split(COORDINATE_SEPARATOR);
        if (tokens.length != 2) {
            throw new Exception("Expected 2 tokens found " + tokens.length);
        }
        try {
            double latitude = Double.parseDouble(tokens[0]);
            double longitude = Double.parseDouble(tokens[1]);
            return new Coordinate(latitude, longitude);
        }
        catch (Exception e) {
            throw new Exception("An error occurred parsing the coordinate values", e);
        }
    }

    public Coordinate() {
    }

    public Coordinate(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.latitude);
        sb.append(COORDINATE_SEPARATOR);
        sb.append(this.longitude);
        return sb.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Coordinate [latitude=");
        builder.append(this.latitude);
        builder.append(", longitude=");
        builder.append(this.longitude);
        builder.append("]");
        return builder.toString();
    }
}

