/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class Cache<K, V> {
    protected int limit;
    protected Map<K, V> cache;
    protected boolean enableStatistics;
    protected long hints;
    protected long requests;
    protected long removed;

    public Cache(final int limit) {
        this.limit = limit;
        this.hints = 0L;
        this.cache = new LinkedHashMap<K, V>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                boolean remove;
                boolean bl = remove = this.size() > limit;
                if (remove) {
                    ++Cache.this.removed;
                }
                return remove;
            }
        };
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public long getRequests() {
        return this.requests;
    }

    public int getLimit() {
        return this.limit;
    }

    public long getHints() {
        return this.hints;
    }

    public V get(K key) {
        V value = this.cache.get(key);
        if (this.enableStatistics) {
            ++this.requests;
            if (value != null) {
                ++this.hints;
            }
        }
        return value;
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Cache [limit=");
        builder.append(this.limit);
        builder.append(", enableStatistics=");
        builder.append(this.enableStatistics);
        builder.append(", hints=");
        builder.append(this.hints);
        builder.append(", requests=");
        builder.append(this.requests);
        builder.append(", removed=");
        builder.append(this.removed);
        builder.append("]");
        return builder.toString();
    }
}

