/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.gcube.data.spd.obisplugin.PluginSession;
import org.gcube.data.spd.obisplugin.pool.DatabaseCredential;
import org.gcube.data.spd.obisplugin.pool.ObjectPool;

public class PluginSessionPool
extends ObjectPool<PluginSession> {
    protected Logger logger = Logger.getLogger(PluginSessionPool.class);
    protected DatabaseCredential databaseCredential;

    public PluginSessionPool(DatabaseCredential databaseCredential) {
        super("PluginSessionPool", 1800000L);
        this.setDatabaseCredential(databaseCredential);
    }

    public void setDatabaseCredential(DatabaseCredential databaseCredential) {
        this.databaseCredential = databaseCredential;
    }

    @Override
    protected PluginSession create() {
        try {
            Connection connection = this.createConnection();
            return new PluginSession(this.databaseCredential, connection);
        }
        catch (SQLException e) {
            this.logger.error((Object)"An error occurred creating the db connection", (Throwable)e);
            return null;
        }
    }

    protected Connection createConnection() throws SQLException {
        Properties props = new Properties();
        props.setProperty("user", this.databaseCredential.getUser());
        props.setProperty("password", this.databaseCredential.getPassword());
        return DriverManager.getConnection(this.databaseCredential.getUrl(), props);
    }

    @Override
    protected boolean validate(PluginSession session) {
        try {
            return session.isValid(this.databaseCredential);
        }
        catch (Exception e) {
            this.logger.warn((Object)"An error occurred validating the session", (Throwable)e);
            return false;
        }
    }

    @Override
    protected void expire(PluginSession session) {
        try {
            session.expire();
        }
        catch (SQLException e) {
            this.logger.warn((Object)"An error occurred expiring the session", (Throwable)e);
        }
    }
}

