/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.model.products.Product;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.obisplugin.ObisClient;
import org.gcube.data.spd.obisplugin.PluginSession;
import org.gcube.data.spd.obisplugin.Writer;
import org.gcube.data.spd.obisplugin.data.SearchFilters;
import org.gcube.data.spd.obisplugin.pool.PluginSessionPool;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ObisOccurrencesInterface
extends OccurrencesCapability {
    protected static final Set<Conditions> SUPPORTED_PROPERTIES = new HashSet<Conditions>(Arrays.asList(Conditions.values()));
    protected Logger logger = Logger.getLogger(ObisOccurrencesInterface.class);
    protected PluginSessionPool sessionPool;

    public ObisOccurrencesInterface(PluginSessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    public Set<Conditions> getSupportedProperties() {
        return SUPPORTED_PROPERTIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String word, final ObjectWriter<OccurrencePoint> writer, Condition ... properties) {
        final PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            SearchFilters filters = new SearchFilters(properties);
            this.logger.trace((Object)("filters: " + filters));
            ObisClient.searchByScientificName(session, word, filters, new Writer<ResultItem>(){

                @Override
                public boolean write(ResultItem item) {
                    for (Product product : item.getProducts()) {
                        if (product.getType() != Product.ProductType.Occurrence) continue;
                        String key = product.getKey();
                        ObisOccurrencesInterface.this.getOccurrencePoints(session, key, (ObjectWriter<OccurrencePoint>)writer);
                    }
                    return writer.isAlive();
                }
            });
        }
        catch (Exception e) {
            this.logger.debug((Object)"searchByScientificName failed", (Throwable)e);
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getOccurrencesByIds(ClosableWriter<OccurrencePoint> writer, Iterator<String> reader) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            while (reader.hasNext() && writer.isAlive()) {
                String id = reader.next();
                try {
                    OccurrencePoint occurrencePoint = ObisClient.getOccurrenceById(session, id);
                    if (occurrencePoint == null) continue;
                    writer.write((Object)occurrencePoint);
                }
                catch (Exception e) {
                    this.logger.debug((Object)"searchByScientificName failed", (Throwable)e);
                }
            }
            writer.close();
            return;
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOccurrencesByProductKeys(ClosableWriter<OccurrencePoint> writer, Iterator<String> reader) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            while (reader.hasNext() && writer.isAlive()) {
                String key = reader.next();
                this.getOccurrencePoints(session, key, (ObjectWriter<OccurrencePoint>)writer);
            }
            writer.close();
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    protected void getOccurrencePoints(PluginSession session, String key, final ObjectWriter<OccurrencePoint> writer) {
        try {
            ObisClient.getOccurrences(session, key, new Writer<OccurrencePoint>(){

                @Override
                public boolean write(OccurrencePoint item) {
                    writer.write((Object)item);
                    return writer.isAlive();
                }
            });
        }
        catch (Exception e) {
            this.logger.error((Object)("Error getting occurrence points for key " + key), (Throwable)e);
        }
    }
}

