package org.gcube.data.spd.client.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.spd.client.proxies.DWCACreator;
import org.gcube.data.spd.client.proxies.DefaultDWCACreator;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.stubs.DWCACreatorPortType;
import org.gcube.data.spd.stubs.IdNotValidFault;
import org.gcube.data.spd.stubs.service.DWCACreatorServiceAddressingLocator;

public class DWCACreatorPlugin extends AbstractPlugin<DWCACreatorPortType, DWCACreator> {

	public DWCACreatorPlugin() {
		super("gcube/data/speciesproductsdiscovery/dwcacreator");
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
						
		if (fault instanceof IdNotValidFault){
			System.out.println("inside");
			return new IdNotValidException();
		}
		return fault;
	}

	@Override
	public DWCACreatorPortType resolve(EndpointReferenceType address,
			ProxyConfig<?, ?> config) throws Exception {
		return new DWCACreatorServiceAddressingLocator().getDWCACreatorPortTypePort(address);
	}

	@Override
	public DWCACreator newProxy(
			ProxyDelegate<DWCACreatorPortType> delegate) {
		return new DefaultDWCACreator(delegate);
	}

	
}
