package org.gcube.data.spd.client.proxies;

import static org.gcube.common.clients.exceptions.FaultDSL.again;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.types.VOID;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.stubs.DWCACreatorPortType;
import org.gcube.data.spd.stubs.StatusResponse;

public class DefaultDWCACreator implements DWCACreator{

	private final ProxyDelegate<DWCACreatorPortType> delegate; 
			
	public DefaultDWCACreator(ProxyDelegate<DWCACreatorPortType> delegate) {
		super();
		this.delegate = delegate;
	}

	@Override
	public String getByChilds(final String taxonKey) {
		Call<DWCACreatorPortType, String> call = new Call<DWCACreatorPortType, String>() {
			@Override
			public String call(DWCACreatorPortType dwcaPT) throws Exception {
				return dwcaPT.getByChilds(taxonKey);
			}
		};
		try {
			return delegate.make(call);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}

	}

	@Override
	public String getResultLink(final String jobId) throws IdNotValidException{
		Call<DWCACreatorPortType, String> call = new Call<DWCACreatorPortType, String>() {
			@Override
			public String call(DWCACreatorPortType dwcaPT) throws Exception {
				return dwcaPT.getResultLink(jobId);
			}
		};
		try {
			return delegate.make(call);
		}catch(Exception e) {
			throw again(e).as(IdNotValidException.class);
		}

	}

	@Override
	public StatusResponse getStatus(final String jobId) throws IdNotValidException{
		Call<DWCACreatorPortType, StatusResponse> call = new Call<DWCACreatorPortType, StatusResponse>() {
			@Override
			public StatusResponse call(DWCACreatorPortType dwcaPT) throws Exception {
				return dwcaPT.getStatus(jobId);
			}
		};
		try {
			return delegate.make(call);
		}catch(Exception e) {
			throw again(e).as(IdNotValidException.class);
		}

	}

	@Override
	public void removeJob(final String jobId) throws IdNotValidException{
		Call<DWCACreatorPortType, VOID> call = new Call<DWCACreatorPortType, VOID>() {
			@Override
			public VOID call(DWCACreatorPortType dwcaPT) throws Exception {
				return dwcaPT.removeJob(jobId);
			}
		};
		try {
			delegate.make(call);
		}catch(Exception e) {
			throw again(e).as(IdNotValidException.class);
		}
		
	}

}
