package org.gcube.data.spd.client.proxies;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.net.URI;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.spd.client.ResultGenerator;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.PointInfo;
import org.gcube.data.spd.plugin.fwk.model.binding.Bindings;
import org.gcube.data.spd.stubs.OccurrencesPortType;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.exceptions.StreamSkipSignal;
import org.gcube.data.streams.generators.Generator;

import static org.gcube.data.streams.dsl.Streams.*;
import static org.gcube.common.clients.exceptions.FaultDSL.*;

public class DefaultOccurrences implements Occurrences {

	private final ProxyDelegate<OccurrencesPortType> delegate;
	
	private final ResultGenerator<OccurrencePoint> occurrencesGenerator = new ResultGenerator<OccurrencePoint>();
	
	public DefaultOccurrences(ProxyDelegate<OccurrencesPortType> config){
		this.delegate = config;
	}
	
	@Override
	public Stream<OccurrencePoint> getByIds(Stream<String> ids) {
		final String idsLocator = publishStringsIn(ids).withDefaults().toString();
		Call<OccurrencesPortType, URI> call = new Call<OccurrencesPortType, URI>() {
			@Override
			public URI call(OccurrencesPortType occurrencesPT) throws Exception {
				return new URI(occurrencesPT.getByIds(idsLocator));
			}
		};
		try {
			return pipe(convert(delegate.make(call)).of(GenericRecord.class).withDefaults()).through(occurrencesGenerator);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
	}

	@Override
	public Stream<OccurrencePoint> getByKeys(Stream<String> keys) {
		final String idsLocator = publishStringsIn(keys).withDefaults().toString();
		Call<OccurrencesPortType, URI> call = new Call<OccurrencesPortType, URI>() {
			@Override
			public URI call(OccurrencesPortType occurrencesPT) throws Exception {
				return new URI(occurrencesPT.getByKeys(idsLocator));
			}
		};
		try {
			return pipe(convert(delegate.make(call)).of(GenericRecord.class).withDefaults()).through(occurrencesGenerator);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
	}
	
	@Override
	public String createLayer(Stream<PointInfo> coordinatesStream) {
		Stream<String> convertedStream = pipe(coordinatesStream).through(new Generator<PointInfo, String>() {

			@Override
			public String yield(PointInfo element) {
				try {
					return Bindings.toXml(element);
				} catch (Exception e) {
					throw new StreamSkipSignal();
				}
			}
			
		});
		
		final String coordinateLocator = publishStringsIn(convertedStream).withDefaults().toString();
		
		Call<OccurrencesPortType, String> call = new Call<OccurrencesPortType, String>() {
			@Override
			public String call(OccurrencesPortType occurrencesPT) throws Exception {
				return occurrencesPT.createLayer(coordinateLocator);
			}
		};
		
		try {
			return delegate.make(call);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}	
	}


}
