package org.gcube.data.spd.stubs.types;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class PluginDescription {

	@XmlElement
	private String name;
	
	@XmlElement
	private String description;
	
	@XmlElement(name="searchableBy")
	private List<String> searchableBy;
	
	@XmlElement
	private RepositoryInfo repositoryInfo;
	
	@XmlElement(name="capabilities")
	private List<CapabilityDescription> capabilities;
	
	public String getName() {
		return name;
	}

	public List<String> getSearchableBy() {
		return searchableBy;
	}

	public RepositoryInfo getRepositoryInfo() {
		return repositoryInfo;
	}

	public List<CapabilityDescription> getCapabilities() {
		return capabilities;
	}
	
	public String getDescription() {
		return description;
	}

	@Override
	public String toString() {
		return "PluginDescription [name=" + name + ", searchableBy="
				+ searchableBy + ", repositoryInfo=" + repositoryInfo
				+ ", capabilities=" + capabilities + "]";
	}

	
}
