/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.proxies;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.net.URI;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.spd.client.ResultGenerator;
import org.gcube.data.spd.client.proxies.Classification;
import org.gcube.data.spd.model.TaxonomyItem;
import org.gcube.data.spd.stubs.ClassificationStub;
import org.gcube.data.spd.stubs.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.stubs.exceptions.UnsupportedCapabilityException;
import org.gcube.data.spd.stubs.exceptions.UnsupportedPluginException;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;

public class DefaultClassification
implements Classification {
    private final ProxyDelegate<ClassificationStub> delegate;
    private final ResultGenerator<TaxonomyItem> taxonItemGenerator = new ResultGenerator();

    public DefaultClassification(ProxyDelegate<ClassificationStub> config) {
        this.delegate = config;
    }

    @Override
    public Stream<TaxonomyItem> getTaxonChildrenById(final String id) throws UnsupportedPluginException, UnsupportedCapabilityException, InvalidIdentifierException {
        Call<ClassificationStub, URI> call = new Call<ClassificationStub, URI>(){

            public URI call(ClassificationStub classification) throws Exception {
                return new URI(classification.retrieveTaxonChildrenByTaxonId(id));
            }
        };
        try {
            return Streams.pipe((Stream)Streams.convert((URI)((URI)this.delegate.make((Call)call))).of(GenericRecord.class).withDefaults()).through(this.taxonItemGenerator);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Stream<TaxonomyItem> getTaxaByIds(Stream<String> ids) {
        final String idsLocator = Streams.publishStringsIn(ids).withDefaults().toString();
        Call<ClassificationStub, URI> call = new Call<ClassificationStub, URI>(){

            public URI call(ClassificationStub classification) throws Exception {
                return new URI(classification.getTaxaByIds(idsLocator));
            }
        };
        try {
            return Streams.pipe((Stream)Streams.convert((URI)((URI)this.delegate.make((Call)call))).of(GenericRecord.class).withDefaults()).through(this.taxonItemGenerator);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Stream<TaxonomyItem> getTaxonTreeById(final String id) throws UnsupportedPluginException, UnsupportedCapabilityException, InvalidIdentifierException {
        Call<ClassificationStub, URI> call = new Call<ClassificationStub, URI>(){

            public URI call(ClassificationStub classification) throws Exception {
                return new URI(classification.retrieveChildrenTreeById(id));
            }
        };
        try {
            return Streams.pipe((Stream)Streams.convert((URI)((URI)this.delegate.make((Call)call))).of(GenericRecord.class).withDefaults()).through(this.taxonItemGenerator);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Stream<TaxonomyItem> getSynonymsById(final String id) throws UnsupportedPluginException, UnsupportedCapabilityException, InvalidIdentifierException {
        Call<ClassificationStub, URI> call = new Call<ClassificationStub, URI>(){

            public URI call(ClassificationStub classification) throws Exception {
                return new URI(classification.retrieveSynonymsById(id));
            }
        };
        try {
            return Streams.pipe((Stream)Streams.convert((URI)((URI)this.delegate.make((Call)call))).of(GenericRecord.class).withDefaults()).through(this.taxonItemGenerator);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

