package org.gcube.data.spd.model.service;


import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import org.gcube.data.spd.model.service.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.model.service.exceptions.InvalidInputException;
import org.gcube.data.spd.model.service.exceptions.InvalidJobException;
import org.gcube.data.spd.model.service.types.CompleteJobStatus;
import org.gcube.data.spd.model.service.types.SubmitJob;


@WebService(name=Constants.executor_portType,targetNamespace=Constants.executor_target_namespace)
public interface ExecutorStubs {

	@SOAPBinding(parameterStyle=ParameterStyle.BARE)	
	String submitJob(SubmitJob input ) throws InvalidInputException, InvalidJobException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)	
	String getResultLink(String id) throws InvalidIdentifierException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)	
	String getErrorLink(String id) throws InvalidIdentifierException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)
	CompleteJobStatus getStatus(String id) throws InvalidIdentifierException; 
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)
	void removeJob(String id) throws InvalidIdentifierException; 
	
}
