/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.specieslink;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.model.BasisOfRecord;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.parser.DarwinSimpleRecord;
import org.gcube.data.spd.parser.RecordsIterator;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.specieslink.SpeciesLinkPlugin;
import org.gcube.data.spd.specieslink.Utils;

public class OccurrencesCapabilityImpl
extends OccurrencesCapability {
    GCUBELog logger = new GCUBELog(OccurrencesCapabilityImpl.class);

    public Set<Conditions> getSupportedProperties() {
        return new HashSet<Conditions>(){
            {
                this.add(Conditions.DATE);
                this.add(Conditions.COORDINATE);
            }
        };
    }

    private static BasisOfRecord matchBasisOfRecord(String value) {
        if (value != null) {
            BasisOfRecord[] basisOfRecordArray = BasisOfRecord.values();
            int n = basisOfRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                BasisOfRecord record = basisOfRecordArray[n2];
                if (record.name().toLowerCase().equals(value.toLowerCase())) {
                    return record;
                }
                ++n2;
            }
            if (value.toLowerCase().equals("S".toLowerCase())) {
                return BasisOfRecord.PreservedSpecimen;
            }
            if (value.toLowerCase().equals("Fotot".toLowerCase())) {
                return BasisOfRecord.MachineObservation;
            }
        }
        return BasisOfRecord.HumanObservation;
    }

    public void searchByScientificName(String scientificName, ObjectWriter<OccurrencePoint> writer, Condition ... properties) {
        this.logger.trace((Object)("searchByScientificName " + scientificName + " in SpeciesLink"));
        String f = "";
        try {
            f = Utils.elaborateProps(properties);
        }
        catch (Exception e) {
            this.logger.error((Object)"error elaborating properties", (Throwable)e);
            return;
        }
        try {
            String filter = "http://rs.tdwg.org/dwc/dwcore/ScientificName%20like%20%22" + scientificName.replace(" ", "%20") + "%22" + f + "&orderBy=http://rs.tdwg.org/dwc/dwcore/ScientificName&orderBy=http://rs.tdwg.org/dwc/dwcore/InstitutionCode";
            this.createElement(SpeciesLinkPlugin.baseurl, filter, SpeciesLinkPlugin.model, SpeciesLinkPlugin.limit, writer);
        }
        catch (Exception e) {
            this.logger.error((Object)"General Error", (Throwable)e);
            writer.write((StreamException)new StreamBlockingException("SpeciesLink", ""));
        }
    }

    private void createElement(String url, String filter, String model, int limit, ObjectWriter<OccurrencePoint> writer) {
        RecordsIterator set = new RecordsIterator(url, filter, model, limit);
        RecordsIterator it = set.iterator();
        DarwinSimpleRecord element = null;
        while (it.hasNext()) {
            element = (DarwinSimpleRecord)it.next();
            OccurrencePoint a = new OccurrencePoint(element.globalUniqueIdentifier);
            a.setScientificNameAuthorship(element.authorYearOfScientificName);
            if (element.basisOfRecord != null) {
                a.setBasisOfRecord(OccurrencesCapabilityImpl.matchBasisOfRecord(element.basisOfRecord));
            }
            a.setCatalogueNumber(element.catalogNumber);
            a.setIdentifiedBy(element.identifiedBy);
            a.setCollectionCode(element.collectionCode);
            a.setCountry(element.country);
            if (element.decimalLatitude != null) {
                a.setDecimalLatitude(Double.parseDouble(element.decimalLatitude));
            }
            if (element.decimalLongitude != null) {
                a.setDecimalLongitude(Double.parseDouble(element.decimalLongitude));
            }
            a.setFamily(element.family);
            a.setInstitutionCode(element.institutionCode);
            a.setKingdom(element.kingdom);
            a.setLocality(element.country);
            if (element.maximumDepthInMeters != null) {
                a.setMaxDepth(Double.parseDouble(element.maximumDepthInMeters));
            }
            if (element.minimumDepthInMeters != null) {
                a.setMinDepth(Double.parseDouble(element.minimumDepthInMeters));
            }
            a.setModified(element.dateLastModified);
            a.setScientificName(element.scientificName);
            a.setCredits(Utils.credits());
            a.setCitation(Utils.citation());
            if (a == null || !writer.isAlive()) break;
            writer.write((Object)a);
        }
    }

    public void getOccurrencesByProductKeys(ClosableWriter<OccurrencePoint> writer, Iterator<String> keys) {
        try {
            while (keys.hasNext()) {
                String key = keys.next();
                this.logger.trace((Object)("getOccurrencesByProductKeys " + key + " in SpeciesLink"));
                this.createElement(SpeciesLinkPlugin.baseurl, key, SpeciesLinkPlugin.model, SpeciesLinkPlugin.limit, (ObjectWriter<OccurrencePoint>)writer);
            }
        }
        catch (Exception e) {
            writer.write((StreamException)new StreamBlockingException("SpeciesLink", ""));
        }
    }

    public void getOccurrencesByIds(ClosableWriter<OccurrencePoint> writer, Iterator<String> ids) {
        try {
            while (ids.hasNext()) {
                String id = ids.next();
                this.logger.trace((Object)("getOccurrencesByIds " + id + " in SpeciesLink"));
                String filter = "http://rs.tdwg.org/dwc/terms/occurrenceID%20equals%20%22" + id + "%22";
                this.createElement(SpeciesLinkPlugin.baseurl, filter, SpeciesLinkPlugin.model, SpeciesLinkPlugin.limit, (ObjectWriter<OccurrencePoint>)writer);
            }
        }
        catch (Exception e) {
            writer.write((StreamException)new StreamBlockingException("SpeciesLink", ""));
        }
    }
}

