/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.spql.stmt;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.gcube.dataaccess.spql.stmt.AbstractStatement;

public class WhereStatement
extends AbstractStatement {
    protected SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
    protected boolean first = true;

    protected WhereStatement(StringBuilder query) {
        super(query);
    }

    protected void checkFirst() {
        if (this.first) {
            this.query.append(" where");
        }
        this.first = false;
    }

    protected void addBoundCondition(String bound, float latitude, float longitude) {
        this.checkFirst();
        this.query.append(" ");
        this.query.append(bound);
        this.query.append(" IS ");
        this.query.append(latitude);
        this.query.append(",");
        this.query.append(longitude);
    }

    public WhereStatement lowerBoundIs(float latitude, float longitude) {
        this.addBoundCondition("lowerBound", latitude, longitude);
        return this;
    }

    public WhereStatement upperBoundIs(float latitude, float longitude) {
        this.addBoundCondition("upperBound", latitude, longitude);
        return this;
    }

    protected void addDateCondition(String dateCondition, Date date) {
        this.checkFirst();
        this.query.append(" ");
        this.query.append(dateCondition);
        this.query.append(" IS ");
        this.query.append(this.simpleDateFormat.format(date));
    }

    public WhereStatement fromDateIs(Date date) {
        this.addDateCondition("fromDate", date);
        return this;
    }

    public WhereStatement toDateIs(Date date) {
        this.addDateCondition("toDate", date);
        return this;
    }
}

