/**
 * 
 */
package org.gcube.dataaccess.spql.stmt;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class WhereStatement extends AbstractStatement {
	
	protected SimpleDateFormat simpleDateFormat;
	protected boolean first;

	protected WhereStatement(StringBuilder query) {
		super(query);
		first = true;
		simpleDateFormat = new SimpleDateFormat();
	}
	
	protected void checkFirst()
	{
		if (first) query.append(" where");
		first = false;
	}
	
	protected void addBoundCondition(String bound, float latitude, float longitude)
	{
		checkFirst();
		query.append(" ");
		query.append(bound);
		query.append(" IS ");
		query.append(latitude);
		query.append(",");
		query.append(longitude);
	}
	
	public WhereStatement lowerBoundIs(float latitude, float longitude)
	{
		addBoundCondition("lowerBound", latitude, longitude);
		return this;
	}
	
	public WhereStatement upperBoundIs(float latitude, float longitude)
	{
		addBoundCondition("upperBound", latitude, longitude);
		return this;
	}
	
	protected void addDateCondition(String dateCondition, Date date)
	{
		checkFirst();
		query.append(" ");
		query.append(dateCondition);
		query.append(" IS ");
		query.append(simpleDateFormat.format(date));
	}
	
	public WhereStatement fromDateIs(Date date)
	{
		addDateCondition("fromDate", date);
		return this;
	}
	
	public WhereStatement toDateIs(Date date)
	{
		addDateCondition("toDate", date);
		return this;
	}

}
