package org.gcube.data.spd.parser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DarwinSimpleRecord {

	GCUBELog logger = new GCUBELog(DarwinSimpleRecord.class);
	
	public String occurrenceID;
	public Calendar modified;
	public Calendar eventTime;
	public String basisOfRecord;
	public String institutionCode;
	public String collectionID;
	public String collectionCode;
	public String catalogNumber;
	public String recordedBy;
	public String remarks;
	public String scientificName;
	public String scientificNameAuthorship;
	public String kingdom;
	public String phylum;
	public String clazz;
	public String order;
	public String family;
	public String genus;
	public String specificEpithet;
	public String infraspecificEpithet;
	public String authorYearOfScientificName;
	public String continent;
	public String country;
	public String locality;
	public String stateProvince;
	public int minimumElevationInMeters;
	public int maximumElevationInMeters;
	public int minimumDepthInMeters;
	public int maximumDepthInMeters;
	public String dayOfYear;
	public String collector;
	public String sex;
	public double decimalLatitude;
	public double decimalLongitude;
	public double verbatimLatitude;
	public double verbatimLongitude;
	public String identifiedBy;
	public String collectorNumber;
	public String fieldNumber;
	public String typeStatus;
	public String individualCount;
	public static SimpleDateFormat df=new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");



	public DarwinSimpleRecord(Element eElement){

		try{this.occurrenceID = getTagValue("dwc:occurrenceID", eElement);}catch (Exception e) {}
		try{this.collectionID = getTagValue("dwc:collectionID", eElement);}catch (Exception e) {}
		
		try{this.recordedBy = getTagValue("dwc:recordedBy", eElement);}catch (Exception e) {}
		try{this.scientificNameAuthorship = getTagValue("dwc:scientificNameAuthorship", eElement);}catch (Exception e) {}

		try{this.scientificName = getTagValue("dwc:scientificName", eElement);}catch (Exception e) {}
		try{this.authorYearOfScientificName = getTagValue("dwc:authorYearOfScientificName", eElement);}catch (Exception e) {}

		//		System.out.println(getTagValue("dwc:BasisOfRecord", eElement));

		//		this.basisOfRecord = matchBasisOfRecord(getTagValue("dwc:BasisOfRecord", eElement));
		try{this.basisOfRecord = getTagValue("dwc:basisOfRecord", eElement);}catch (Exception e) {}

		try{this.catalogNumber = getTagValue("dwc:catalogNumber", eElement);}catch (Exception e) {}
		try{this.clazz = getTagValue("dwc:class", eElement);}catch (Exception e) {}
		try{this.collectionCode = getTagValue("dwc:collectionCode", eElement);}catch (Exception e) {}
		try{this.collector = getTagValue("dwc:collector", eElement);}catch (Exception e) {}
		try{this.collectorNumber = getTagValue("dwc:collectorNumber", eElement);}catch (Exception e) {}
		try{this.continent = getTagValue("dwc:continent", eElement);}catch (Exception e) {}
		try{this.country = getTagValue("dwc:country", eElement);}catch (Exception e) {}

		//Calendar
		String modifiedDate = null;
		try{modifiedDate = getTagValue("dc:modified", eElement);}catch (Exception e) {}
		if (modifiedDate!=null)
			this.modified = getCalendar(modifiedDate);

		String eventTimeDate = null;
		try{eventTimeDate = getTagValue("dwc:eventDate", eElement);}catch (Exception e) {}
		if (eventTimeDate!=null)
			this.eventTime = getCalendar(eventTimeDate);

		try{this.dayOfYear = getTagValue("dwc:dayOfYear", eElement);}catch (Exception e) {}
		try{this.family = getTagValue("dwc:family", eElement);}catch (Exception e) {}
		try{this.fieldNumber = getTagValue("dwc:fieldNumber", eElement);}catch (Exception e) {}
		try{this.genus = getTagValue("dwc:genus", eElement);}catch (Exception e) {}
		try{this.identifiedBy = getTagValue("dwc:identifiedBy", eElement);}catch (Exception e) {}
		try{this.individualCount = getTagValue("dwc:individualCount", eElement);}catch (Exception e) {}
		try{this.infraspecificEpithet = getTagValue("dwc:infraspecificEpithet", eElement);}catch (Exception e) {}
		try{this.institutionCode = getTagValue("dwc:institutionCode", eElement);}catch (Exception e) {}
		try{this.kingdom = getTagValue("dwc:kingdom", eElement);}catch (Exception e) {}
		try{this.locality = getTagValue("dwc:locality", eElement);}catch (Exception e) {}
		try{this.order = getTagValue("dwc:order", eElement);}catch (Exception e) {}
		try{this.phylum = getTagValue("dwc:phylum", eElement);}catch (Exception e) {}
		try{this.remarks = getTagValue("dwc:remarks", eElement);}catch (Exception e) {}
		try{this.sex = getTagValue("dwc:sex", eElement);}catch (Exception e) {}
		try{this.specificEpithet = getTagValue("dwc:specificEpithet", eElement);}catch (Exception e) {}
		try{this.stateProvince = getTagValue("dwc:stateProvince", eElement);}catch (Exception e) {}
		try{this.typeStatus = getTagValue("dwc:typeStatus", eElement);}catch (Exception e) {}

		try{ this.decimalLatitude = Double.parseDouble(getTagValue("dwc:DecimalLatitude", eElement));}		
		catch(NumberFormatException e) {}

		try{this.decimalLongitude = Double.parseDouble(getTagValue("dwc:DecimalLongitude", eElement));}
		catch(NumberFormatException e) {}

		try{this.maximumDepthInMeters = Integer.parseInt(getTagValue("dwc:MaximumDepthInMeters", eElement));}
		catch(NumberFormatException e) {}

		try{this.maximumElevationInMeters = Integer.parseInt(getTagValue("dwc:MaximumElevationInMeters", eElement));}
		catch(NumberFormatException e) {}

		try{this.minimumDepthInMeters = Integer.parseInt(getTagValue("dwc:MinimumDepthInMeters", eElement));}
		catch(NumberFormatException e) {}

		try{this.minimumElevationInMeters = Integer.parseInt(getTagValue("dwc:MinimumElevationInMeters", eElement));}
		catch(NumberFormatException e) {}

		try{this.verbatimLatitude = Double.parseDouble(getTagValue("dwc:VerbatimLatitude", eElement));}
		catch(NumberFormatException e) {}

		try{this.verbatimLongitude = Double.parseDouble(getTagValue("dwc:VerbatimLongitude", eElement));}
		catch(NumberFormatException e) {}

	}


	private Calendar getCalendar(String myDate) {
		Calendar dateC = null;
		try {

			myDate = myDate.replace("T", " ");
			dateC = dateString2Calendar(myDate);

		} catch (ParseException e) {
			logger.error("ParseException" , e);
		}
		return dateC;
	}


	//Returns the tag value
	private String getTagValue(String sTag, Element eElement){	
		String a = "";

		//	NodeList nlList = eElement.getElementsByTagName(sTag).item(0).getChildNodes();

		NodeList nlList = eElement.getElementsByTagName(sTag);
		if (nlList!= null){	
			Element xmlNode = (Element)nlList.item(0);
			if (xmlNode != null){
				NodeList textFNList = xmlNode.getChildNodes();
				if (textFNList != null){
					Node nValue = (Node) textFNList.item(0);  
					if (nValue != null)						
						a = nValue.getNodeValue(); 				
				}
			}
		}
		// System.out.println(a);
		return a;
	}


	private Calendar dateString2Calendar(String s) throws ParseException {
		Calendar cal=Calendar.getInstance();
		try{
			Date d1=df.parse(s);
			cal.setTime(d1);
		}
		catch (Exception e) {
			return null;
		}
		return cal;
	}

}
