/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.library.utils;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.message.MessageElement;
import org.gcube.common.core.faults.ExceptionProxy;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.datatransfer.agent.library.outcome.FileTransferOutcome;
import org.gcube.datatransfer.agent.stubs.datatransferagent.AnyHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Utils {
    public static GCUBEClientLog logger = new GCUBEClientLog(Utils.class, new Properties[0]);
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static Pattern getPattern(AnyHolder h) throws Exception {
        return h == null ? null : (Pattern)Patterns.getUnMarshaller().unmarshal((org.w3c.dom.Node)h.get_any()[0].getAsDOM());
    }

    public static AnyHolder toHolder(Pattern p) throws Exception {
        if (p == null) {
            return null;
        }
        Document filterNode = factory.newDocumentBuilder().newDocument();
        Patterns.getMarshaller().marshal((Object)p, (org.w3c.dom.Node)filterNode);
        return Utils.toHolder(filterNode.getDocumentElement());
    }

    public static AnyHolder toHolder(Element e) {
        return e == null ? null : new AnyHolder(new MessageElement[]{new MessageElement(e)});
    }

    public static AnyHolder toHolder(Node n) throws Exception {
        return n == null ? null : Utils.toHolder(Bindings.nodeToElement((Node)n, (QName[])new QName[0]));
    }

    public static void setCurrentScope(GCUBEScope scope) {
        GCUBEScopeManager.DEFAULT.setScope(scope);
    }

    public static void copyfile(File f1, File f2) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static <E extends GCUBEFault> E newFault(E fault, Throwable cause) {
        fault.setFaultMessage(cause.getMessage());
        fault.removeFaultDetail(new QName("http://xml.apache.org/axis/", "stackTrace"));
        StringWriter w = new StringWriter();
        cause.printStackTrace(new PrintWriter(w));
        fault.addFaultDetailString(w.toString());
        try {
            fault.addFaultDetail(ExceptionProxy.newInstance((Throwable)cause).toElement());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fault;
    }

    public static void copyfileToFolder(File file, File outFolder, String fileName) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(file);
        FileOutputStream out = new FileOutputStream(outFolder.getAbsolutePath() + File.separator + fileName);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static ArrayList<FileTransferOutcome> getOutcomes(String outcomeRSURI) throws Exception {
        ForwardReader reader = new ForwardReader(new URI(outcomeRSURI));
        ArrayList<FileTransferOutcome> outcomes = new ArrayList<FileTransferOutcome>();
        for (GenericRecord rec : reader) {
            if (rec == null) continue;
            StringField fileNamefield = (StringField)rec.getField("FileNameField");
            logger.debug((Object)("FileName :" + fileNamefield.getPayload()));
            StringField outcomeField = (StringField)rec.getField("OutcomeField");
            logger.debug((Object)("Outcome :" + outcomeField.getPayload()));
            StringField exceptionField = (StringField)rec.getField("ExceptionField");
            logger.debug((Object)("Exception: " + exceptionField.getPayload()));
            FileTransferOutcome outcome = new FileTransferOutcome(fileNamefield.getPayload());
            outcome.setException(exceptionField.getPayload());
            outcomes.add(outcome);
        }
        try {
            reader.close();
        }
        catch (GRS2ReaderException e1) {
            e1.printStackTrace();
        }
        return outcomes;
    }
}

