/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.library;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.Future;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.Callback;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.datatransfer.agent.library.DataSource;
import org.gcube.datatransfer.agent.library.DataStorage;
import org.gcube.datatransfer.agent.library.TransferOptions;
import org.gcube.datatransfer.agent.library.exceptions.CancelTransferException;
import org.gcube.datatransfer.agent.library.exceptions.ConfigurationException;
import org.gcube.datatransfer.agent.library.exceptions.GetTransferOutcomesException;
import org.gcube.datatransfer.agent.library.exceptions.MonitorTransferException;
import org.gcube.datatransfer.agent.library.exceptions.TransferException;
import org.gcube.datatransfer.agent.library.grs.GRSFileWriter;
import org.gcube.datatransfer.agent.library.outcome.FileTransferOutcome;
import org.gcube.datatransfer.agent.library.outcome.TransferOutcome;
import org.gcube.datatransfer.agent.library.outcome.TreeTransferOutcome;
import org.gcube.datatransfer.agent.library.proxies.AgentService;
import org.gcube.datatransfer.agent.library.proxies.AgentServiceAsync;
import org.gcube.datatransfer.agent.library.utils.Utils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CancelTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DataTransferAgentPortType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.InputPattern;
import org.gcube.datatransfer.agent.stubs.datatransferagent.OutUriData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StartTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

public class AgentLibrary
implements AgentService,
AgentServiceAsync {
    private final AsyncProxyDelegate<DataTransferAgentPortType> delegate;
    public GCUBELog logger = new GCUBELog(this.getClass());

    static {
        ArrayList<PortRange> ports = new ArrayList<PortRange>();
        ports.add(new PortRange(4000, 4050));
        try {
            TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(InetAddress.getLocalHost().getHostName(), ports, true));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }

    public AgentLibrary(ProxyDelegate<DataTransferAgentPortType> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    @Override
    public ArrayList<TreeTransferOutcome> startTransferSync(Pattern patternInput, String inputSourceID, String outputStorageId) {
        final StartTransferMessage message = new StartTransferMessage();
        message.setSyncOp(true);
        DestData dest = new DestData();
        dest.setOutSourceId(outputStorageId);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        SourceData source = new SourceData();
        InputPattern input = new InputPattern();
        try {
            input.setPattern(Utils.toHolder(patternInput));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        input.setSourceId(inputSourceID);
        source.setInputSource(input);
        source.setScope(ScopeProvider.instance.get());
        source.setType(TransferType.TreeBasedTransfer);
        message.setSource(source);
        Call<DataTransferAgentPortType, ArrayList<TreeTransferOutcome>> call = new Call<DataTransferAgentPortType, ArrayList<TreeTransferOutcome>>(){

            public ArrayList<TreeTransferOutcome> call(DataTransferAgentPortType endpoint) throws Exception {
                return Utils.getTreeOutcomes(endpoint.startTransfer(message));
            }
        };
        try {
            return (ArrayList)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ArrayList<FileTransferOutcome> startTransferSync(ArrayList<URI> inputURIs, String outputFolder, TransferOptions options) throws TransferException, ConfigurationException {
        if (options.getType().getValue().compareTo(StorageType.StorageManager.getValue()) == 0 && options.getStorageManagerDetails() == null) {
            throw new ConfigurationException("The Storage Manager configuration details are missing");
        }
        final StartTransferMessage message = new StartTransferMessage();
        message.setSyncOp(true);
        DestData dest = new DestData();
        OutUriData outURI = new OutUriData();
        if (outputFolder.startsWith("/")) {
            outputFolder = outputFolder.substring(1);
        }
        outURI.setOutUris(new String[]{outputFolder});
        outURI.setOverwrite(options.isOverwriteFile());
        outURI.setStorageType(options.getType());
        outURI.setUnzip(options.isUnzipFile());
        if (options.getType().getValue().compareTo(StorageType.StorageManager.getValue()) == 0) {
            outURI.setStorageManagerDetails(options.getStorageManagerDetails());
        }
        dest.setOutUri(outURI);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        SourceData source = new SourceData();
        String[] uris = new String[inputURIs.size()];
        int i = 0;
        while (i < inputURIs.size()) {
            uris[i] = inputURIs.get(i).toString();
            ++i;
        }
        source.setInputURIs(uris);
        source.setScope(ScopeProvider.instance.get());
        source.setType(TransferType.FileBasedTransfer);
        message.setSource(source);
        Call<DataTransferAgentPortType, ArrayList<? extends TransferOutcome>> call = new Call<DataTransferAgentPortType, ArrayList<? extends TransferOutcome>>(){

            public ArrayList<? extends TransferOutcome> call(DataTransferAgentPortType endpoint) throws Exception {
                return Utils.getFileOutcomes(endpoint.startTransfer(message));
            }
        };
        try {
            return (ArrayList)this.delegate.make((Call)call);
        }
        catch (TransferException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public String startTransfer(ArrayList<URI> inputURIs, String outputFolder, TransferOptions options) throws TransferException, ConfigurationException {
        if (options.getType().getValue().compareTo(StorageType.StorageManager.getValue()) == 0 && options.getStorageManagerDetails() == null) {
            throw new ConfigurationException("The Storage Manager configuration details are missing");
        }
        final StartTransferMessage message = new StartTransferMessage();
        message.setSyncOp(false);
        DestData dest = new DestData();
        OutUriData outURI = new OutUriData();
        if (outputFolder.startsWith("/")) {
            outputFolder = outputFolder.substring(1);
        }
        outURI.setOutUris(new String[]{outputFolder});
        outURI.setOverwrite(options.isOverwriteFile());
        outURI.setStorageType(options.getType());
        outURI.setUnzip(options.isUnzipFile());
        if (options.getType().getValue().compareTo(StorageType.StorageManager.getValue()) == 0) {
            outURI.setStorageManagerDetails(options.getStorageManagerDetails());
        }
        dest.setOutUri(outURI);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        SourceData source = new SourceData();
        String[] uris = new String[inputURIs.size()];
        int i = 0;
        while (i < inputURIs.size()) {
            uris[i] = inputURIs.get(i).toString();
            ++i;
        }
        source.setInputURIs(uris);
        source.setScope(ScopeProvider.instance.get());
        source.setType(TransferType.FileBasedTransfer);
        message.setSource(source);
        Call<DataTransferAgentPortType, String> call = new Call<DataTransferAgentPortType, String>(){

            public String call(DataTransferAgentPortType endpoint) throws Exception {
                return endpoint.startTransfer(message);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (TransferException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void cancelTransfer(String transferId, boolean forceCancel) throws CancelTransferException {
        final CancelTransferMessage cancelMessage = new CancelTransferMessage();
        cancelMessage.setForceStop(forceCancel);
        cancelMessage.setTransferID(transferId);
        Call<DataTransferAgentPortType, String> call = new Call<DataTransferAgentPortType, String>(){

            public String call(DataTransferAgentPortType endpoint) throws Exception {
                return endpoint.cancelTransfer(cancelMessage);
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (CancelTransferException cancelTransferException) {
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ArrayList<FileTransferOutcome> copyLocalFiles(ArrayList<File> inputFiles, String destinationFolder, boolean overwrite, boolean unzip) throws TransferException {
        GRSFileWriter writer = null;
        try {
            writer = new GRSFileWriter((IWriterProxy)new TCPWriterProxy(), inputFiles);
        }
        catch (GRS2WriterException e1) {
            e1.printStackTrace();
        }
        final StartTransferMessage message = new StartTransferMessage();
        message.setSyncOp(true);
        SourceData sourceData = new SourceData();
        sourceData.setScope(ScopeProvider.instance.get());
        try {
            sourceData.setInputURIs(new String[]{writer.getLocator().toString()});
        }
        catch (GRS2WriterException e1) {
            e1.printStackTrace();
        }
        sourceData.setType(TransferType.LocalFileBasedTransfer);
        DestData destData = new DestData();
        OutUriData uri = new OutUriData();
        if (destinationFolder.startsWith("/")) {
            destinationFolder = destinationFolder.substring(1);
        }
        uri.setOutUris(new String[]{destinationFolder});
        uri.setOverwrite(overwrite);
        uri.setUnzip(unzip);
        destData.setOutUri(uri);
        message.setSource(sourceData);
        message.setDest(destData);
        writer.start();
        try {
            writer.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Call<DataTransferAgentPortType, ArrayList<FileTransferOutcome>> call = new Call<DataTransferAgentPortType, ArrayList<FileTransferOutcome>>(){

            public ArrayList<FileTransferOutcome> call(DataTransferAgentPortType endpoint) throws Exception {
                return Utils.getFileOutcomes(endpoint.startTransfer(message));
            }
        };
        try {
            return (ArrayList)this.delegate.make((Call)call);
        }
        catch (TransferException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public Future<?> startTransfer(Pattern patternInput, String inputSourceID, String outputStorageId, Callback callback) {
        final StartTransferMessage message = new StartTransferMessage();
        message.setSyncOp(false);
        DestData dest = new DestData();
        dest.setOutSourceId(outputStorageId);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        SourceData source = new SourceData();
        InputPattern input = new InputPattern();
        try {
            input.setPattern(Utils.toHolder(patternInput));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        input.setSourceId(inputSourceID);
        source.setInputSource(input);
        source.setScope(ScopeProvider.instance.get());
        source.setType(TransferType.TreeBasedTransfer);
        message.setSource(source);
        Call<DataTransferAgentPortType, String> call = new Call<DataTransferAgentPortType, String>(){

            public String call(DataTransferAgentPortType endpoint) throws Exception {
                return endpoint.startTransfer(message);
            }
        };
        try {
            return this.delegate.makeAsync((Call)call, callback);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public Future<?> startTransfer(ArrayList<URI> inputURIs, String outputFolder, TransferOptions options, Callback callback) throws ConfigurationException {
        final StartTransferMessage message = new StartTransferMessage();
        message.setSyncOp(true);
        DestData dest = new DestData();
        OutUriData outURI = new OutUriData();
        if (outputFolder.startsWith("/")) {
            outputFolder = outputFolder.substring(1);
        }
        outURI.setOutUris(new String[]{outputFolder});
        outURI.setOverwrite(options.isOverwriteFile());
        outURI.setStorageType(options.getType());
        outURI.setUnzip(options.isUnzipFile());
        if (options.getType().getValue().compareTo(StorageType.StorageManager.getValue()) == 0) {
            outURI.setStorageManagerDetails(options.getStorageManagerDetails());
        }
        dest.setOutUri(outURI);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        SourceData source = new SourceData();
        String[] uris = new String[inputURIs.size()];
        int i = 0;
        while (i < inputURIs.size()) {
            uris[i] = inputURIs.get(i).toString();
            ++i;
        }
        source.setInputURIs(uris);
        source.setScope(ScopeProvider.instance.get());
        source.setType(TransferType.FileBasedTransfer);
        message.setSource(source);
        Call<DataTransferAgentPortType, ArrayList<? extends TransferOutcome>> call = new Call<DataTransferAgentPortType, ArrayList<? extends TransferOutcome>>(){

            public ArrayList<? extends TransferOutcome> call(DataTransferAgentPortType endpoint) throws Exception {
                if (message.getSource().getType().getValue().compareTo(TransferType.FileBasedTransfer.getValue()) == 0) {
                    return Utils.getFileOutcomes(endpoint.startTransfer(message));
                }
                return Utils.getTreeOutcomes(endpoint.startTransfer(message));
            }
        };
        try {
            return this.delegate.makeAsync((Call)call, callback);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public String monitorTransfer(final String transferId) throws MonitorTransferException {
        Call<DataTransferAgentPortType, String> call = new Call<DataTransferAgentPortType, String>(){

            public String call(DataTransferAgentPortType endpoint) throws Exception {
                return endpoint.monitorTransfer(transferId);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (MonitorTransferException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <T extends TransferOutcome> ArrayList<T> getTransferOutcomes(final String transferId, final Class<T> outcomeType) throws GetTransferOutcomesException {
        Call call = new Call<DataTransferAgentPortType, ArrayList<T>>(){

            public ArrayList<T> call(DataTransferAgentPortType endpoint) throws Exception {
                if (outcomeType.getClass() == FileTransferOutcome.class.getClass()) {
                    return Utils.getFileOutcomes(endpoint.getTransferOutcomes(transferId));
                }
                return Utils.getTreeOutcomes(endpoint.getTransferOutcomes(transferId));
            }
        };
        try {
            return (ArrayList)this.delegate.make(call);
        }
        catch (GetTransferOutcomesException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public String startTransfer(DataSource source, DataStorage storage, TransferOptions options) throws ConfigurationException, TransferException {
        return null;
    }
}

