package org.gcube.datatransfer.agent.library.fws;

import static javax.jws.soap.SOAPBinding.ParameterStyle.*;
import static org.gcube.datatransfer.agent.library.fws.Constants.*;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.datatransfer.common.agent.Types.*;


@WebService(name=porttypeLocalName,targetNamespace=porttypeNS)
public interface AgentServiceJAXWSStubs {
	
	@SOAPBinding(parameterStyle=BARE)
	public String monitorTransfer(String s);
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)
	public String startTransfer(StartTransferMessage req);
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)
	public String cancelTransfer(CancelTransferMessage req);


	@SOAPBinding(parameterStyle=ParameterStyle.BARE)
	public MonitorTransferReportMessage monitorTransferWithProgress(String s);


	@SOAPBinding(parameterStyle=BARE)
	public String getTransferOutcomes(String s);
	
	
	@SOAPBinding(parameterStyle=BARE)
	public String getLocalSources(String s);
}

