package org.gcube.datatransfer.agent.impl.context;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.datatransfer.agent.impl.event.Events.TransferTopics;
import org.gcube.datatransfer.agent.impl.event.Events;
import org.gcube.datatransfer.agent.impl.event.TransferEventConsumer;
import org.gcube.datatransfer.agent.impl.utils.Constants;

/**
 * 
 * 
 * @author Andrea Manzi (CERN)
 * 
 */
public class ServiceContext extends GCUBEServiceContext {

	public static final String JNDI_NAME = "gcube/datatransfer/agent";
	
	protected static final ServiceContext cache = new ServiceContext();
	
	private  boolean useMessaging= false;

	
	private ServiceContext() {}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public String[] getSupportedTransfers() throws Exception{
		String[] transfers = null;

		try {
			transfers = ((String)getProperty("supportedTransfers",true)).split(",");	 
		}catch (RuntimeException e) {
			logger.debug("No Transfers available");
			throw new Exception("No Transfers available");
		}
		return transfers;
	}
	/**
	 * 
	 * @return ServiceContext
	 */
	public static ServiceContext getContext() {
		return cache;
	}

	/**
	 * @return the JNDI name
	 */
	@Override
	public String getJNDIName() {
		return JNDI_NAME;
	}
	
	@Override 
	protected void onInitialisation() throws Exception {
		//read from jndi
		this.setUseMessaging(((Boolean)getProperty(Constants.USEMESSAGING_JNDI_NAME)).booleanValue());
		
	}
	
	@Override 
	protected void onReady() throws Exception {
		super.onReady();
		
	
		logger.trace("creating agent resources in all RI scopes");
		AgentContext agentContext = AgentContext.getContext();
		for (GCUBEScope scope : this.getInstance().getScopes().values()) {
			this.setScope(scope);
			agentContext.createAgent();
			
		}
	
		
		logger.trace("creating transfer subscription");
		
		for (TransferTopics topic :TransferTopics.values()) {
			transferEventproducer.subscribe(new TransferEventConsumer(),topic);
		}
		
	}
	
	public boolean getUseMessaging() {
		return useMessaging;
	}

	public void setUseMessaging(boolean useMessaging) {
		this.useMessaging = useMessaging;
	}
	
	public static GCUBEProducer<Events.TransferTopics,Object> transferEventproducer = new GCUBEProducer<Events.TransferTopics,Object>();  
	
}