package org.gcube.datatransfer.agent.impl.worker;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

import org.gcube.common.core.utils.logging.GCUBELog;
//import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;

/**
 * 
 * 
 * @author andrea
 *
 */
public class StorageManagerWorker extends Worker<SourceData, DestData> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	GCUBELog logger = new GCUBELog(StorageManagerWorker.class);
	
	public StorageManagerWorker(SourceData source, DestData dest) {
		this.sourceParameters = source;
		this.destParameters = dest;
	}

	@Override
	public Object call() {
		//Handler.activateProtocol();
		URL smsHome = null;
		try {
			smsHome = new URL(sourceParameters.getInputURIs()[0]);
		} catch (MalformedURLException e1) {
			e1.printStackTrace();
		}
		URLConnection uc = null;
		InputStream in = null;
		FileOutputStream out = null;
		try {
			uc = ( URLConnection ) smsHome.openConnection ( );
			in = uc.getInputStream();
			File file = new File(new URI(destParameters.getOutUri().getOutUris()[0]));
			if (file.exists() && !(destParameters.getOutUri().isOverwrite())) 
				logger.error("The Destination URI Already Exists and the Overwrite policy is set to false");
			out =  new FileOutputStream(file);
			int nextChar;
			while ( ( nextChar = in.read() ) != -1  ) 
				out.write(nextChar );
			out.flush();
		}catch (Exception e){e.printStackTrace();return false;}
		finally{
			try {
				out.close();
				in.close();
				
			} catch (IOException e) {
				e.printStackTrace();
			}
			
		}
		return true;
	
	}
	

}
